/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fisheye.StoppableVisitor;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

public class CriteriaBatchedInClauseHelper<S> {
    private final Session session;
    private final Class criteriaClass;
    private final Consumer<Criteria> criteriaConsumer;
    private final String parameter;
    private final Iterable<S> objects;

    public CriteriaBatchedInClauseHelper(Session session, Class criteriaClass, Consumer<Criteria> criteriaConsumer, String parameter, Iterable<S> objects) {
        this.session = session;
        this.criteriaClass = criteriaClass;
        this.criteriaConsumer = criteriaConsumer;
        this.parameter = parameter;
        this.objects = objects;
    }

    public <T> void execute(StoppableVisitor<T> visitor) {
        for (List subList : Iterables.partition(this.objects, (int)CrucibleSysProps.SQL_IN_CLAUSE_SIZE_LIMIT)) {
            Criteria criteria = this.session.createCriteria(this.criteriaClass);
            criteria.add(Restrictions.in((String)this.parameter, (Collection)subList));
            this.criteriaConsumer.accept(criteria);
            for (Object object : HibernateUtil.typedList(criteria)) {
                if (visitor.visit(object)) continue;
                return;
            }
        }
    }
}

