/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class AlsoViewingCache {
    protected static final long TTL_SECONDS = 25L;
    private final LoadingCache<String, LoadingCache<FecruUser, FecruUser>> alsoViewingCache = this.newCacheBuilder(CacheBuilder.newBuilder().expireAfterAccess(25L, TimeUnit.SECONDS)).build((CacheLoader)new CacheLoader<String, LoadingCache<FecruUser, FecruUser>>(){

        public LoadingCache<FecruUser, FecruUser> load(String reviewKey) throws Exception {
            return AlsoViewingCache.this.newCacheBuilder(CacheBuilder.newBuilder().expireAfterAccess(25L, TimeUnit.SECONDS)).build((CacheLoader)new CacheLoader<FecruUser, FecruUser>(){

                public FecruUser load(FecruUser user) throws Exception {
                    return user;
                }
            });
        }
    });

    @VisibleForTesting
    protected <K, V> CacheBuilder<K, V> newCacheBuilder(CacheBuilder<K, V> builder) {
        return builder;
    }

    public List<FecruUser> updateAndGetUsersViewingReview(String reviewKey, final FecruUser currentUser) {
        try {
            LoadingCache viewingReviewCache = (LoadingCache)this.alsoViewingCache.get((Object)reviewKey);
            if (currentUser != null) {
                viewingReviewCache.get((Object)currentUser);
            }
            return ImmutableList.copyOf((Iterable)Iterables.filter(viewingReviewCache.asMap().keySet(), (Predicate)new Predicate<FecruUser>(){

                public boolean apply(FecruUser alsoViewing) {
                    return !alsoViewing.equals(currentUser);
                }
            }));
        }
        catch (ExecutionException e2) {
            Logs.APP_LOG.warn((Object)("Unexpected exception generating 'also-viewing' list for review=" + reviewKey + ", user=" + (currentUser == null ? "Anon" : currentUser.getUsername())), (Throwable)e2);
            return Collections.emptyList();
        }
    }
}

