/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.upload;

import com.atlassian.crucible.spi.services.FileData;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.util.IdToPathMapper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;
import org.hibernate.Session;

public class UploadManager {
    private static final String UPLOAD_DIR_NAME = "data/uploads";

    public static File getUploadDir() {
        File dir = new File(AppConfig.getVarDir(), UPLOAD_DIR_NAME);
        IOHelper.ensureDirectoryExists(dir);
        return dir;
    }

    private static void saveItemFile(UploadItem item, String content) throws IOException {
        File newFile = UploadManager.createFileForUploadItem(item);
        IOHelper.copyStringToFile(content, Charset.forName(item.getCharset()), newFile);
    }

    private static void saveItemFile(UploadItem item, byte[] content) throws IOException {
        File newFile = UploadManager.createFileForUploadItem(item);
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        IOHelper.copyStream((InputStream)in, newFile);
    }

    private static void saveItemFile(UploadItem item, InputStream content) throws IOException {
        File newFile = UploadManager.createFileForUploadItem(item);
        IOHelper.copyStream(content, newFile);
    }

    private static File createFileForUploadItem(UploadItem item) throws IOException {
        File newFile = UploadManager.getItemFile(item);
        File dir = newFile.getParentFile();
        dir.mkdirs();
        if (!dir.isDirectory()) {
            Logs.APP_LOG.error((Object)("Could not create upload directory: " + dir));
            throw new IOException("Could not create directory to store upload.");
        }
        return newFile;
    }

    public static File getItemFile(UploadItem ui) {
        int id = ui.getId();
        File dir = new File(UploadManager.getUploadDir(), IdToPathMapper.storageDirName(id));
        return new File(dir, id + ".dat");
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadItem createUploadItem(FecruUser user, String filename, File file, String contentType, String description, String charset) throws IOException {
        UploadItem uploadItem;
        FileInputStream in = new FileInputStream(file);
        try {
            uploadItem = UploadManager.createUploadItem(user, filename == null ? file.getName() : filename, in, contentType, description, charset);
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
        return uploadItem;
    }

    public static UploadItem createUploadItem(FecruUser user, String filename, InputStream file, String contentType, String description, String charset) throws IOException {
        UploadItem ui = UploadManager.makeUploadItem(user, filename, contentType, description, charset);
        UploadManager.saveItemFile(ui, file);
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadItem createUploadItem(FecruUser user, FileData file) throws IOException {
        UploadItem uploadItem;
        UploadItem ui = UploadManager.makeUploadItem(user, file.getName(), file.getContentType(), file.getDescription(), file.getCharSet() == null ? Charset.defaultCharset().name() : file.getCharSet());
        File newFile = UploadManager.createFileForUploadItem(ui);
        FileOutputStream out = new FileOutputStream(newFile);
        try {
            file.getContents((OutputStream)out);
            uploadItem = ui;
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
        return uploadItem;
    }

    public static UploadItem createUploadItem(FecruUser user, String filename, String content, String contentType, String description) throws IOException {
        UploadItem ui = UploadManager.makeUploadItem(user, filename, contentType, description, "UTF-8");
        UploadManager.saveItemFile(ui, content);
        return ui;
    }

    private static UploadItem makeUploadItem(FecruUser user, String filename, String contentType, String description, String charset) {
        UploadItem ui = new UploadItem(user, description);
        UploadManager.session().save((Object)ui);
        ui.setOriginalName(filename);
        ui.setOriginalContentType(contentType);
        ui.setCharset(charset);
        return ui;
    }

    public static UploadItem getItemById(Integer id) {
        return (UploadItem)UploadManager.session().get(UploadItem.class, (Serializable)id);
    }

    public static void deleteUpload(UploadItem uploadItem) {
        IOHelper.deleteFile(UploadManager.getItemFile(uploadItem));
        UploadManager.session().delete((Object)uploadItem);
    }

    public static FileRevisionExtraInfo getFrxForPath(Review review, String path) {
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            CrucibleRevision rev = frx.getFileRevision();
            if (!rev.getSourceName().equals("UPLOAD:" + review.getId()) || !rev.getPath().equals(path)) continue;
            return frx;
        }
        return null;
    }

    public static FileRevisionInfo getFromFRI(UploadItem fromUi, String author, String fromUploadFileName, String description, String contentType, FileRevisionExtraInfo frx) {
        int displayRevisionNumber = 1;
        if (frx != null) {
            displayRevisionNumber += frx.getCrucibleRevisions().size();
        }
        String displayRevision = String.valueOf(displayRevisionNumber);
        return new FileRevisionInfo(null, null, fromUi.getId().toString(), displayRevision, author, fromUploadFileName, new Date(), description, false, !UploadManager.isText(contentType, fromUi.getItemFile()), false, true, true, false, false, false, null, null, false);
    }

    public static FileRevisionInfo getToFRI(UploadItem toUi, CrucibleRevision fromRev, String author, String toUploadFileName, String description, String contentType, FileRevisionExtraInfo frx) {
        int displayRevisionNumber = 1;
        if (frx != null) {
            displayRevisionNumber += frx.getCrucibleRevisions().size();
        }
        int offset = 0;
        if (!(fromRev == null || frx != null && frx.getCrucibleRevisions().contains(fromRev))) {
            ++offset;
        }
        String displayRevision = String.valueOf(displayRevisionNumber += offset);
        return new FileRevisionInfo(null, fromRev == null ? null : fromRev.getRevInfoKey(), toUi.getId().toString(), displayRevision, author, toUploadFileName, new Date(), description, false, !UploadManager.isText(contentType, toUi.getItemFile()), false, true, fromRev == null, fromRev != null, false, false, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isText(String contentType, File file) {
        boolean bl;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            bl = UploadManager.isText(contentType, new BufferedInputStream(in));
        }
        catch (IOException e2) {
            boolean bl2;
            try {
                Logs.APP_LOG.error((Object)"problem reading upload item file.", (Throwable)e2);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                throw throwable;
            }
            IOHelper.close(in);
            return bl2;
        }
        IOHelper.close(in);
        return bl;
    }

    @VisibleForTesting
    static boolean isText(String contentType, InputStream in) throws IOException {
        if (UploadManager.isText(contentType)) {
            return true;
        }
        boolean text = true;
        byte[] buf = new byte[4];
        in.mark(5);
        int len = in.read(buf);
        if (len > 1) {
            boolean bl = text = UploadManager.isEqual(buf[0], 254) && UploadManager.isEqual(buf[1], 255) || UploadManager.isEqual(buf[0], 255) && UploadManager.isEqual(buf[1], 254);
        }
        if (len > 2 && !text) {
            boolean bl = text = UploadManager.isEqual(buf[0], 239) && UploadManager.isEqual(buf[1], 187) && UploadManager.isEqual(buf[2], 191);
        }
        if (len > 3 && !text) {
            boolean bl = text = UploadManager.isEqual(buf[0], 0) && UploadManager.isEqual(buf[1], 0) && UploadManager.isEqual(buf[2], 254) && UploadManager.isEqual(buf[3], 255);
        }
        if (!text) {
            int b2;
            in.reset();
            text = true;
            for (len = 0; (b2 = in.read()) != -1 && len < 20000; ++len) {
                if (b2 != 0 && b2 <= 127) continue;
                text = false;
                break;
            }
        }
        return text;
    }

    private static boolean isEqual(byte b2, int i2) {
        return (b2 & 0xFF) == i2;
    }

    private static boolean isText(String contentType) {
        return contentType != null && contentType.startsWith("text");
    }
}

