/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tetris;

import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.tetris.TetrisLine;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TetrisGrid {
    private Map<FRXRevision, HunkList> hunkLists = new HashMap<FRXRevision, HunkList>();

    public void setHunkList(FRXRevision rev, HunkList list) {
        this.hunkLists.put(rev, list);
    }

    public Map<FRXRevision, List<TetrisLine>> getTetrisGrid() throws Exception {
        HashMap<FRXRevision, List<TetrisLine>> tetrisGrid = new HashMap<FRXRevision, List<TetrisLine>>();
        for (FRXRevision key : this.hunkLists.keySet()) {
            HunkList hunkList = this.hunkLists.get(key);
            List<Object> sections = hunkList == null ? new ArrayList() : hunkList.getSections();
            ArrayList<TetrisLine> tetrisLines = (ArrayList<TetrisLine>)tetrisGrid.get(key);
            if (tetrisLines == null) {
                tetrisLines = new ArrayList<TetrisLine>();
            }
            for (Section section : sections) {
                int index;
                Hunk hunk = section.getHunk();
                if (section.isCommonSubsequence()) {
                    for (int i2 = 0; i2 < hunk.getFromCount(); ++i2) {
                        index = hunk.getFrom() + i2;
                        if (index >= tetrisLines.size()) {
                            for (int j2 = tetrisLines.size(); j2 <= index; ++j2) {
                                tetrisLines.add(null);
                            }
                        }
                        tetrisLines.set(index, new TetrisLine(hunk.getTo() + i2, hunk.getTo() + i2, false, true));
                    }
                    continue;
                }
                if (hunk.isAdd()) continue;
                for (int i2 = 0; i2 < hunk.getFromCount(); ++i2) {
                    index = hunk.getFrom() + i2;
                    if (index >= tetrisLines.size()) {
                        for (int j2 = tetrisLines.size(); j2 <= index; ++j2) {
                            tetrisLines.add(null);
                        }
                    }
                    int offset = hunk.isDelete() ? 0 : 1;
                    tetrisLines.set(index, new TetrisLine(hunk.getTo(), hunk.getTo() + hunk.getToCount() - offset, hunk.isDelete(), false));
                }
            }
            tetrisGrid.put(key, tetrisLines);
        }
        return tetrisGrid;
    }
}

