/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags.wiki;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.Timer;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class WikiTextRendererTag
extends SimpleTagSupport {
    private static final String ELLIPSES = "&#8230;";
    private static final Pattern IMAGE_PATTERN = Pattern.compile("(?:^!.*[^\\\\]!)|(?:[^\\\\]!.*[^\\\\]!)");
    private WikiRenderer wikiRenderer;
    protected CharSequence wikiText;
    private Review review;
    private String space;
    private String eol;
    private boolean replaceNewlinesWithBreaks;
    private boolean replaceNewlinesWithSpaces;
    private String repName;
    private boolean plain;
    private int maxHeight = -1;
    private int maxCharacters = -1;
    private boolean wasTruncated;

    public void doTag() throws JspException, IOException {
        String renderedWikiText;
        Timer timer = new Timer("wiki-render");
        Writer out = this.getOut();
        CrucibleRenderContext crucibleRenderContext = this.makeRenderContext();
        String wikiText = this.trimToConstraint(this.wikiText.toString());
        if (this.plain) {
            crucibleRenderContext.pushRenderMode(RenderMode.PHRASES_LINKS);
            String text = this.getWikiRenderer().render((CharSequence)wikiText, (RenderContext)crucibleRenderContext);
            if (this.replaceNewlinesWithSpaces) {
                text = text.replace("\n", " ");
            } else if (this.replaceNewlinesWithBreaks) {
                text = text.replace("\n", "<br>");
            }
            renderedWikiText = text;
            if (renderedWikiText.length() < wikiText.length()) {
                this.wasTruncated = true;
            }
        } else {
            renderedWikiText = this.getWikiRenderer().render((CharSequence)wikiText, (RenderContext)crucibleRenderContext);
        }
        out.append(renderedWikiText);
        if (this.wasTruncated) {
            out.append(ELLIPSES);
        }
        timer.end(" l=" + wikiText.length());
    }

    private String trimToConstraint(String wikiText) throws IOException {
        String trimmedWikiText = wikiText;
        if (this.maxHeight > 0) {
            String line;
            int nlines = 0;
            int end = 0;
            ReaderLineReader lines = new ReaderLineReader(new StringReader(wikiText));
            while (null != (line = lines.readLine())) {
                if (++nlines > this.maxHeight) {
                    trimmedWikiText = wikiText.substring(0, end);
                    this.wasTruncated = true;
                    break;
                }
                end += line.length();
            }
        }
        if (this.maxCharacters > 0 && trimmedWikiText.length() > this.maxCharacters) {
            trimmedWikiText = trimmedWikiText.substring(0, this.maxCharacters);
            this.wasTruncated = true;
        } else if (this.plain && (this.maxCharacters > 0 || this.maxHeight > 0) && IMAGE_PATTERN.matcher(trimmedWikiText).find()) {
            this.wasTruncated = true;
        }
        trimmedWikiText = StringUtil.stripEOL(trimmedWikiText);
        return trimmedWikiText;
    }

    protected Writer getOut() {
        return this.getJspContext().getOut();
    }

    protected CrucibleRenderContext makeRenderContext() {
        return (CrucibleRenderContext)this.getWikiRenderer().setupRenderContextProperties((RenderContext)new CrucibleRenderContext(this.getReview(), this.getSpace(), this.getEol(), this.getRepName()));
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void setPlain(boolean plain) {
        this.plain = plain;
    }

    public void setWikiText(String wikiText) {
        this.wikiText = wikiText;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public String getRepName() {
        return this.repName;
    }

    public void setRepName(String repName) {
        this.repName = repName;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public String getSpace() {
        return this.space;
    }

    public String getEol() {
        return this.eol;
    }

    public void setReplaceNewlinesWithBreaks(boolean replaceNewlinesWithBreaks) {
        this.replaceNewlinesWithBreaks = replaceNewlinesWithBreaks;
    }

    public boolean isReplaceNewlinesWithBreaks() {
        return this.replaceNewlinesWithBreaks;
    }

    public void setReplaceNewlinesWithSpaces(boolean replaceNewlinesWithSpaces) {
        this.replaceNewlinesWithSpaces = replaceNewlinesWithSpaces;
    }

    public boolean isReplaceNewlinesWithSpaces() {
        return this.replaceNewlinesWithSpaces;
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    protected WikiRenderer getWikiRenderer() {
        if (this.wikiRenderer == null) {
            this.wikiRenderer = (WikiRenderer)SpringContext.getComponent("crucibleWikiRenderer");
        }
        return this.wikiRenderer;
    }
}

