/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags.wiki;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.cenqua.crucible.tags.wiki.HtmlToTextConverter;
import com.cenqua.crucible.tags.wiki.WikiTextRendererTag;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public final class RenderAsPlainTextTag
extends WikiTextRendererTag {
    @Override
    public void doTag() throws JspException, IOException {
        CrucibleRenderContext renderContext = this.makeRenderContext();
        String html = this.getWikiRenderer().render(this.wikiText, (RenderContext)renderContext);
        String text = this.convert(html);
        String abbreviatedText = StringUtils.abbreviate((String)this.clean(text), (int)this.getMaxCharacters());
        this.getOut().append(StringEscapeUtils.escapeHtml((String)abbreviatedText));
    }

    @Override
    protected CrucibleRenderContext makeRenderContext() {
        CrucibleRenderContext renderContext = super.makeRenderContext();
        renderContext.pushRenderMode(RenderMode.ALL_WITH_NO_MACRO_ERRORS);
        return renderContext;
    }

    public String convert(String html) {
        try {
            return new HtmlToTextConverter().convert(html, false);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("Could not convert HTML extract to text:\n------" + html + "\n------"), (Throwable)e2);
            return "";
        }
    }

    private String clean(String text) {
        return text.replace('\n', ' ');
    }
}

