/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.cenqua.crucible.model.Review;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class UserTextRendererTag
extends AbstractRegionListTag {
    private String text;
    private String defaultText;
    private String defaultTextClass;
    private String repname;
    private String project;
    private int maxChars;

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setReview(Review review) {
        if (review != null) {
            this.repname = review.getProject().getDefaultRepositoryName();
            this.project = review.getProject().getProjKey();
        }
    }

    public void setRepname(String repname) {
        this.repname = repname;
    }

    public void doTag() throws IOException {
        String outputText = this.text;
        if (StringUtils.isNotEmpty((String)this.defaultText) && StringUtils.isBlank((String)outputText)) {
            StringBuilder sb = new StringBuilder();
            sb.append("<span");
            if (!Strings.isNullOrEmpty((String)this.defaultTextClass)) {
                sb.append(" class='" + this.defaultTextClass + "'");
            }
            sb.append(">").append(this.defaultText).append("</span>");
            this.getOut().write(sb.toString());
        } else {
            int trailingDots;
            if (this.maxChars > 0 && outputText.length() > this.maxChars && (trailingDots = UserTextRendererTag.countTrailing(outputText = StringUtil.firstLineOf(outputText, this.maxChars, true, true, false), '.')) < 3) {
                outputText = outputText + StringUtils.repeat((String)".", (int)(3 - trailingDots));
            }
            RegionList regions = this.makeRegions(outputText);
            this.outputRegion(outputText, regions, 0, outputText.length());
        }
    }

    private RegionList makeRegions(String s2) {
        RegionList regions = new RegionList();
        regions.add(new Region(0, s2.length(), Collections.singletonMap("findlinks", "true")));
        this.getLinker().insertLinks(s2, regions);
        return regions;
    }

    protected Linker getLinker() {
        return this.getLinkerService().getLinker(this.repname, this.project);
    }

    protected LinkerService getLinkerService() {
        return SpringContext.getComponentByClass(LinkerService.class);
    }

    @Override
    protected String getSpanClass(Region region) {
        return LinkerFactory.getPopupLinkSpanClass(region);
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public void setDefaultTextClass(String defaultTextClass) {
        this.defaultTextClass = defaultTextClass;
    }

    @VisibleForTesting
    static int countTrailing(String text, char c2) {
        int count = 0;
        for (int i2 = text.length() - 1; i2 >= 0 && text.charAt(i2) == c2; --i2) {
            ++count;
        }
        return count;
    }
}

