/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.tags.MaybeReview;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ReviewUtil {
    public static final int MAX_TITLE_LENGTH = 100;
    private static EffectiveUserProvider effectiveUserProvider;

    private static EffectiveUserProvider getEffectiveUserProvider() {
        if (effectiveUserProvider == null) {
            effectiveUserProvider = (EffectiveUserProvider)SpringContext.getComponent("effectiveUserProvider");
        }
        return effectiveUserProvider;
    }

    public static void resetEffectiveUserProvider() {
        effectiveUserProvider = null;
    }

    private static Principal getEffectivePrincipal() {
        return ReviewUtil.getEffectiveUserProvider().getEffectivePrincipal();
    }

    public static FecruUser getEffectiveUser() {
        return ReviewUtil.getEffectiveUserProvider().getEffectiveUser();
    }

    private static PermissionManager getPermissionManager() {
        return SpringContext.getComponent(PermissionManager.class, "permissionManager");
    }

    private static ProjectManager getProjectManager() {
        return SpringContext.getComponent(ProjectManager.class, "projectManager");
    }

    public static List<StateTransition> getStateActions(Review review) {
        return ReviewUtil.getStateActions(ReviewUtil.getEffectivePrincipal(), review, null);
    }

    public static List<StateTransition> getStateActions(Principal principal, Review review, AllowedTransitionsCache cache) {
        LinkedList<StateTransition> allowedTrans;
        PrincipalReviewStringKey key = PrincipalReviewStringKey.create(principal, review, review.getState().getName());
        LinkedList<StateTransition> linkedList = allowedTrans = cache == null ? null : (LinkedList<StateTransition>)cache.get(key);
        if (allowedTrans == null) {
            allowedTrans = new LinkedList<StateTransition>();
            List<StateTransition> trans = review.getState().getStateProgressionActions();
            StateTransition sendToMod = null;
            boolean approveIncluded = false;
            for (StateTransition t2 : trans) {
                if (!ReviewUtil.principalCanDoReviewAction(principal, null, t2.getActionName(), review)) continue;
                if (t2.getActionName().equals(UserActionManager.ACTION_SUBMIT)) {
                    sendToMod = t2;
                }
                if (t2.getActionName().equals(UserActionManager.ACTION_APPROVE)) {
                    approveIncluded = true;
                }
                allowedTrans.add(t2);
            }
            if (approveIncluded && sendToMod != null) {
                allowedTrans.remove(sendToMod);
            }
            if (cache != null) {
                cache.put(key, allowedTrans);
            }
        }
        return allowedTrans;
    }

    public static List<StateTransition> getPrioritizedStateActions(Review review) {
        List<StateTransition> trans = ReviewUtil.getStateActions(review);
        Collections.sort(trans, new Comparator<StateTransition>(){

            @Override
            public int compare(StateTransition stateTransition1, StateTransition stateTransition2) {
                return stateTransition2.getPriority() - stateTransition1.getPriority();
            }
        });
        return trans;
    }

    public static boolean isShowDelete(Review review, FecruUser user) {
        return ReviewUtil.canDoReviewAction(UserActionManager.ACTION_DELETE, review) && user != null && review.getState().isDeletable();
    }

    public static boolean isShowClose(Review review, FecruUser user) {
        return ReviewUtil.canDoReviewAction(UserActionManager.ACTION_CLOSE, review) && user != null && review.getState().isSummarizeState();
    }

    public static boolean isShowComplete(Review review, FecruUser user) {
        return ReviewUtil.canDoReviewAction(UserActionManager.ACTION_COMPLETE, review) && user != null && review.isUncompletedParticipant(user) && review.getState().isReviewState();
    }

    public static boolean isShowUncomplete(Review review, FecruUser user) {
        return ReviewUtil.canDoReviewAction(UserActionManager.ACTION_UNCOMPLETE, review) && user != null && review.isCompletedParticipant(user) && review.getState().isReviewState();
    }

    public static boolean isShowNotifyIncompleteReviewer(Review review) {
        return !Principal.Anonymous.isAnon((Principal)ReviewUtil.getEffectivePrincipal()) && (ReviewUtil.canDoReviewAction("action:summarizeReview", review) || ReviewUtil.canDoReviewAction("action:closeReview", review)) && !review.getReviewers().isEmpty() && review.getState().isOpenMetaState() && !review.isSnippet();
    }

    public static boolean isShowTextReview(Review review) {
        return ReviewUtil.canDoReviewAction("action:viewReview", review);
    }

    public static String snippetDownloadUrl(Review review) {
        if (review.isSnippet()) {
            FileRevisionExtraInfo frx = review.getFrxs().iterator().next();
            CrucibleRevision cruRev = frx.getFileRevision();
            return review.getPermaId() + "/rawcontent/" + cruRev.getId() + "/" + cruRev.getFileName();
        }
        return null;
    }

    public static boolean isShowJoinReview(Review review, FecruUser user) throws DbException {
        return review.isAllowReviewerToJoin() && !ReviewUtil.isParticipant(review, user) && ReviewUtil.isAllowedReviewer(review, user);
    }

    public static boolean isAllowedParticipant(Review review, FecruUser user) throws DbException {
        return !ReviewUtil.isParticipant(review, user) && ReviewUtil.isAllowedReviewer(review, user);
    }

    public static boolean isParticipant(Review review, FecruUser user) {
        return review.getParticipant(user) != null;
    }

    public static boolean isInReview(Review review, CrucibleRevision fr) {
        List<FRXRevision> frxRevs = review.getFRXRevisions();
        for (FRXRevision frxRev : frxRevs) {
            if (!frxRev.getRevision().equals(fr)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAllowedReviewer(Review review, FecruUser user) {
        return ReviewUtil.getProjectManager().isAllowedReviewer(review.getProject(), user);
    }

    public static boolean principalCanDoReviewAction(Principal p2, FecruUser user, String actionName, Review review) {
        PermissionScheme ps = review.getProject().getPermissionScheme();
        return ReviewUtil.getPermissionManager().canPrincipalDoAction(ps, p2, user, actionName, review);
    }

    public static boolean principalCanDoReviewAction(Principal p2, String actionName, Review review, ActionAllowedCache permissionsCache) {
        Boolean allowed;
        PrincipalReviewStringKey key = PrincipalReviewStringKey.create(p2, review, actionName);
        Boolean bl = allowed = permissionsCache == null ? null : (Boolean)permissionsCache.get(key);
        if (allowed == null) {
            PermissionScheme ps = review.getProject().getPermissionScheme();
            allowed = ReviewUtil.getPermissionManager().canPrincipalDoAction(ps, p2, null, actionName, review);
            if (permissionsCache != null) {
                permissionsCache.put(key, allowed);
            }
        }
        return allowed;
    }

    public static Collection<UserActionManager.Action> actionsAllowedForPrincipal(Principal p2, Collection<UserActionManager.Action> actions, Review review) {
        PermissionScheme ps = review.getProject().getPermissionScheme();
        return ReviewUtil.getPermissionManager().canPrincipalDoActions(ps, p2, actions, review);
    }

    public static Collection<UserActionManager.Action> actionsAllowedForPrincipal(Principal p2, Collection<UserActionManager.Action> actions, Review review, AllowedActionsCache actionsCache) {
        if (actionsCache == null) {
            return ReviewUtil.actionsAllowedForPrincipal(p2, actions, review);
        }
        PrincipalReviewKey key = PrincipalReviewKey.create(p2, review);
        Collection<UserActionManager.Action> actionsList = (Collection<UserActionManager.Action>)actionsCache.get(key);
        if (actionsList == null) {
            actionsList = ReviewUtil.actionsAllowedForPrincipal(p2, actions, review);
            actionsCache.put(key, actionsList);
        }
        return actionsList;
    }

    public static boolean principalCanDoProjectAction(Principal principal, String actionName, Project project) {
        PermissionScheme ps = project.getPermissionScheme();
        if (ps == null) {
            Logs.APP_LOG.error((Object)("Project " + project.getProjKey() + " has a null permission scheme."));
            return false;
        }
        return ReviewUtil.getPermissionManager().canPrincipalDoAction(ps, principal, null, actionName, null);
    }

    public static boolean canDoReviewAction(String actionName, Review review) {
        return ReviewUtil.getPermissionManager().canEffectivePrincipalDoReviewAction(review, UserActionManager.Action.getByName(actionName));
    }

    public static Collection<UserActionManager.Action> actionsAllowedForReview(Collection<UserActionManager.Action> actions, Review review) {
        return ReviewUtil.actionsAllowedForPrincipal(ReviewUtil.getEffectivePrincipal(), actions, review);
    }

    public static MaybeReview getSecuredReviewById(Integer id) {
        Review r2 = DefaultReviewManager.get().getReviewById(id);
        if (r2 == null) {
            Logs.APP_LOG.warn((Object)("Review with ID " + id + " not found while getting Review by ID"));
            return new MaybeReview(r2, false);
        }
        return new MaybeReview(r2, ReviewUtil.canDoReviewAction(UserActionManager.ACTION_VIEW, r2));
    }

    public static List<MaybeReview> getSecuredUndeadReviewsById(Collection<Integer> ids) {
        ArrayList<MaybeReview> reviews = new ArrayList<MaybeReview>();
        for (Integer id : ids) {
            MaybeReview mr = ReviewUtil.getSecuredReviewById(id);
            if (mr.getReview() == null || mr.getReview().getState().isTrashMetaState()) continue;
            reviews.add(mr);
        }
        return reviews;
    }

    public static boolean principalCanDoAction(Principal p2, String actionName) {
        SecureProjectManager secureProjectManager = SpringContext.getComponent(SecureProjectManager.class, "secureProjectManager");
        return secureProjectManager.isAtLeastOneProjectCanDoActionIn(p2, UserActionManager.Action.getByName(actionName));
    }

    public static String getProjectKey(String projectKey) {
        ProjectManager projectManager;
        Project p2;
        if (StringUtils.isNotBlank((String)projectKey) && (p2 = (projectManager = SpringContext.getComponent(ProjectManager.class, "projectManager")).getProjectByKey(projectKey)) != null && ReviewUtil.principalCanDoProjectAction(ReviewUtil.getEffectivePrincipal(), UserActionManager.ACTION_CREATE, p2)) {
            return "?projectKey=" + projectKey;
        }
        return "";
    }

    public static Object valueOrDefault(Object value, Object defaultVal) {
        return value == null ? defaultVal : value;
    }

    public static Period makePeriod(int count, String units) {
        int u2 = 6;
        char firstLetter = units.toLowerCase().charAt(0);
        switch (firstLetter) {
            case 'h': {
                u2 = 10;
                break;
            }
            case 'd': {
                u2 = 6;
                break;
            }
            case 'w': {
                u2 = 3;
                break;
            }
            case 'm': {
                u2 = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown unit: " + units + "use hours, days, weeks, months");
            }
        }
        Period p2 = new Period();
        p2.tMinus(count, u2);
        return p2;
    }

    public static String extractReviewTitle(String text) {
        return StringUtil.firstLineOf(text, 100, false, true, true);
    }

    public static class PrincipalReviewStringKey
    extends Triple<Integer, Integer, String> {
        private PrincipalReviewStringKey(int permissionScheme, int participations, String string) {
            super(permissionScheme, participations, string);
        }

        public static PrincipalReviewStringKey create(Principal p2, Review review, String s2) {
            PrincipalReviewKey k2 = PrincipalReviewKey.create(p2, review);
            return new PrincipalReviewStringKey((Integer)k2.getFirst(), (Integer)k2.getSecond(), s2);
        }
    }

    public static class PrincipalReviewKey
    extends Pair<Integer, Integer> {
        private PrincipalReviewKey(Integer comp1, Integer comp2) {
            super(comp1, comp2);
        }

        public static PrincipalReviewKey create(Principal p2, Review review) {
            int permissionScheme = review.getProject().getPermissionScheme().getId();
            int participations = 0;
            if (p2 != null) {
                for (ReviewParticipant rp : review.getParticipants()) {
                    if (!rp.getUser().getUsername().equals(p2.getUserName())) continue;
                    participations = (rp.isAuthor() ? 1 : 0) + (rp.isModerator() ? 2 : 0) + (rp.isReviewer() ? 4 : 0);
                }
            }
            return new PrincipalReviewKey(permissionScheme, participations);
        }
    }

    public static class AllowedTransitionsCache
    extends HashMap<PrincipalReviewStringKey, List<StateTransition>> {
    }

    public static class ActionAllowedCache
    extends HashMap<PrincipalReviewStringKey, Boolean> {
    }

    public static class AllowedActionsCache
    extends HashMap<PrincipalReviewKey, Collection<UserActionManager.Action>> {
    }
}

