/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.model.ContentRoot;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProjectUtil {
    public static List<Project> getVisibleProjects() {
        return ProjectUtil.getVisibleProjects((ProjectManager)SpringContext.getComponent("projectManager"));
    }

    @Deprecated
    public static List<Project> getVisibleProjects(ProjectManager projectManager) {
        Principal p2 = TotalityFilter.getCurrentPrincipal();
        ArrayList<Project> results = new ArrayList<Project>();
        List<Project> all = projectManager.getAllProjects();
        for (Project project : all) {
            if (!ReviewUtil.principalCanDoProjectAction(p2, UserActionManager.ACTION_VIEW, project)) continue;
            results.add(project);
        }
        return results;
    }

    public static Project getProjectById(Integer id) {
        ProjectManager manager = SpringContext.getComponent(ProjectManager.class, "projectManager");
        return manager.getProjectById(id);
    }

    public static RepositoryConstraints generateRepositoryConstraint(Project project) {
        Set<ContentRoot> paths = project.getContentRoots();
        RepositoryConstraints repositoryConstraints = new RepositoryConstraints();
        String defaultRepositoryName = project.getDefaultRepositoryNameIfFisheyeRepository();
        if (!Strings.isNullOrEmpty((String)defaultRepositoryName)) {
            HashSet repos = Sets.newHashSet();
            for (ContentRoot contentRoot : paths) {
                repos.add(contentRoot.getRepName());
            }
            if (!repos.contains(defaultRepositoryName)) {
                repositoryConstraints.includeRepository(defaultRepositoryName);
            }
        }
        for (ContentRoot cr : paths) {
            if (cr.isWholeRepository()) {
                repositoryConstraints.includeRepository(cr.getRepName());
                continue;
            }
            repositoryConstraints.addPath(cr.getRepName(), cr.getPath());
        }
        return repositoryConstraints;
    }

    public static RepositoryConstraints generateRepositoryConstraint(String projectKey) {
        ProjectManager manager = SpringContext.getComponent(ProjectManager.class, "projectManager");
        return ProjectUtil.generateRepositoryConstraint(manager.getProjectByKey(projectKey));
    }
}

