/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Strings;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class MimeLinkTag
extends SimpleTagSupport {
    private String fileName;
    private String src;
    private String target;
    private String revision;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void doTag() throws JspException {
        try {
            JspWriter out = this.getJspContext().getOut();
            if (Strings.isNullOrEmpty((String)this.src) || Strings.isNullOrEmpty((String)this.fileName)) {
                out.print("<!-- Error: null or empty src or fileName. -->");
                return;
            }
            CustomFileNameMap fnm = AppConfig.getsConfig().getRawMimeMap();
            String mime = fnm.getContentTypeFor(this.fileName.toLowerCase());
            out.print("<a href='" + this.src + "' title='" + ExpressionUtil.escapeString(this.fileName) + "' class='" + (mime != null && mime.startsWith("image") ? "mime-image" : "mime-binary") + (this.target != null && mime != null && mime.startsWith("image") ? "' target='" + this.target : "") + "'>");
            if (mime != null && mime.startsWith("image")) {
                out.print("<img src='" + this.src + "' alt='Source Image: " + ExpressionUtil.escapeString(this.fileName) + "'>");
            } else if (Strings.isNullOrEmpty((String)this.revision)) {
                out.print("Download File");
            } else {
                out.print("Download revision " + this.revision);
            }
            out.print("</a>");
        }
        catch (Exception e2) {
            throw new JspException("MimeLinkTag: " + e2.getMessage());
        }
    }
}

