/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public class UploadSource
extends Source {
    public UploadSource(String sourceName, ContentManager contentManager, NotificationManager notificationManager, CommentManager commentManager, EncodedContentProvider encodedContentProvider) {
        super(sourceName, contentManager, notificationManager, commentManager, encodedContentProvider);
    }

    @Override
    public String getChangeSetId(CrucibleRevision crucibleRevision) {
        return null;
    }

    @Override
    public boolean isAvailableGivenLicense(LicenseInfo license) {
        return license.isCrucible();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isAuthorized() {
        return true;
    }

    @Override
    public boolean isAnySuccessorRevisions(CrucibleRevision fr) {
        return FileRevisionManager.getRevisions(fr, false).size() > 0;
    }

    @Override
    public String getLatestRevIdent(CrucibleRevision fr) {
        List<CrucibleRevision> revisions = FileRevisionManager.getRevisions(fr, false);
        if (revisions != null && revisions.size() > 0) {
            return revisions.get(0).getRevision();
        }
        return null;
    }

    public Blame getBlame(CrucibleRevision cruToRev, int lineCount) throws Exception {
        return null;
    }

    @Override
    public IndexedLineReader getFileContents(CrucibleRevision toRev, String ignoredKeywordOptions, Disposer disposer) throws IOException {
        return this.encodedContentProvider.getContent(toRev.getUploadItem(), disposer);
    }

    @Override
    public IndexedLineReader getCachedEncodedFileContents(CrucibleRevision toRev, Disposer disposer) throws Exception {
        return this.getFileContents(toRev, null, disposer);
    }

    @Override
    public void copyFile(CrucibleRevision revision, File file) throws Exception {
        IOHelper.copy(revision.getUploadItem().getItemFile(), file);
    }

    @Override
    public Linker getLinker() {
        return AppConfig.getsConfig().getDefaultLinker();
    }

    @Override
    public List<String> findAuthors(Path path) {
        return FileRevisionManager.getUserNamesForStoredRevisionPath(path.getPath());
    }

    @Override
    public List<String> findBranches(Path path) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getDefaultBranch() {
        return null;
    }

    @Override
    public SearchManager getSearchManager() {
        return null;
    }

    @Override
    public CrucibleChangeSet getChangeSet(String csid, boolean noSizeCheck) {
        return null;
    }

    @Override
    public boolean isFile(Path path) {
        return true;
    }

    @Override
    public boolean isDir(Path path) {
        return false;
    }

    @Override
    public RepositoryExplorer getRepositoryExplorer(Path lpath, WaybackSpec wbSpec, CookiePreferences userPreferences) {
        return null;
    }

    @Override
    public boolean isChangesetCapable() {
        return true;
    }

    @Override
    public boolean isSearchCapable() {
        return false;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public boolean isAllowsAuthorConstraint() {
        return false;
    }

    @Override
    public boolean isAllowsBranchConstraint() {
        return false;
    }

    @Override
    public ChangelogExplorer getChangelogExplorer(Path path, WaybackSpec wbSpec, Review review) {
        return null;
    }

    @Override
    public FileHistoryExplorer getFileHistoryExplorer(RevInfoKey revInfoKey, WaybackSpec wb) {
        return null;
    }

    @Override
    public boolean isAfter(RevInfoKey thisRevisionIdent, RevInfoKey thatRevisionIdent) {
        CrucibleRevision thisRev = FileRevisionManager.findRevision(this.getName(), thisRevisionIdent);
        CrucibleRevision thatRev = FileRevisionManager.findRevision(this.getName(), thatRevisionIdent);
        return thisRev != null && thatRev != null && thisRev.getCommitDate().getTime() > thatRev.getCommitDate().getTime();
    }

    @Override
    public boolean isBefore(RevInfoKey thisRevisionIdent, RevInfoKey thatRevisionIdent) {
        CrucibleRevision thisRev = FileRevisionManager.findRevision(this.getName(), thisRevisionIdent);
        CrucibleRevision thatRev = FileRevisionManager.findRevision(this.getName(), thatRevisionIdent);
        return thisRev != null && thatRev != null && thisRev.getCommitDate().getTime() < thatRev.getCommitDate().getTime();
    }

    @Override
    public boolean isOnAncestryLine(List<CrucibleRevision> existingRevisions, CrucibleRevision from, CrucibleRevision to) throws SourceException {
        for (CrucibleRevision currentRev : existingRevisions) {
            if (from != null && currentRev.getPath().equals(from.getPath()) && currentRev.getPath().equals(to.getPath())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getInsertIndex(List<CrucibleRevision> existingRevisions, CrucibleRevision fr, CrucibleRevision knownMax) throws SourceException {
        this.validateRevisionSource(fr);
        if (!existingRevisions.contains(fr)) {
            boolean needsAdd = true;
            int i2 = 0;
            for (CrucibleRevision currentRev : existingRevisions) {
                this.validateRevisionSource(currentRev);
                if (fr.getCommitDate() != null && fr.getCommitDate().before(currentRev.getCommitDate()) || currentRev.equals(knownMax)) break;
                if (fr.getRevInfoKey().equals(currentRev.getRevInfoKey())) {
                    needsAdd = false;
                    break;
                }
                ++i2;
            }
            if (needsAdd) {
                return i2;
            }
        }
        return -1;
    }

    @Override
    public FileRevisionInfo getFileRevisionInfo(String path, String revision) throws FileRevisionException {
        CrucibleRevision cruRev = FileRevisionManager.findRevision(this.getName(), path, revision);
        if (cruRev == null) {
            throw new FileRevisionException("Revision not found");
        }
        return this.contentManager.loopBackFRI(cruRev);
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate) throws FileRevisionException {
        CrucibleRevision cruRev = FileRevisionManager.findRevision(this.getName(), revInfoKey);
        while (cruRev != null) {
            CrucibleRevision diffRev = this.getAncestor(cruRev);
            if (diffRev == null) {
                diffRev = this.getAncestorByDate(cruRev);
            }
            if (diffRev != null && predicate.apply((Object)diffRev.getRevInfoKey())) {
                return diffRev.getRevInfoKey();
            }
            cruRev = diffRev;
        }
        return null;
    }

    private CrucibleRevision getAncestorByDate(CrucibleRevision cruRev) {
        List<CrucibleRevision> revs = FileRevisionManager.getRevisions(cruRev, true);
        return revs.size() > 0 ? revs.get(0) : null;
    }

    public CrucibleRevision getAncestor(CrucibleRevision cruRev) {
        RevInfoKey diffRevKey = this.contentManager.getDiffRevKeyFromCache(cruRev);
        return diffRevKey == null ? null : this.contentManager.getCrucibleRevision(this, diffRevKey);
    }

    @Override
    public Charset getTextEncoding(CrucibleRevision fr) throws SourceException {
        if (!fr.isStored() || fr.getUploadItem().getCharset() == null) {
            return null;
        }
        return Charset.forName(fr.getUploadItem().getCharset());
    }

    @Override
    public String getDisplayName() {
        return "Local uploads";
    }
}

