/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.DisplayRevisionMapper;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.diff.DiffHelper;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.view.DiffExplorer;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Predicate;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Source
implements DisplayRevisionMapper {
    public static final String SEPARATOR = ":";
    public static final String PATCH_SPACE = "PATCH:";
    public static final String UPLOAD_SPACE = "UPLOAD:";
    protected final EncodedContentProvider encodedContentProvider;
    protected String reason = "";
    private String sourceName = "";
    protected ContentManager contentManager;
    private final NotificationManager notificationManager;
    private final CommentManager commentManager;
    public static final SourceNameComparator COMPARATOR = new SourceNameComparator();

    protected Source(String sourceName, ContentManager contentManager, NotificationManager notificationManager, CommentManager commentManager, EncodedContentProvider encodedContentProvider) {
        this.sourceName = sourceName != null ? sourceName.trim() : null;
        this.contentManager = contentManager;
        this.notificationManager = notificationManager;
        this.commentManager = commentManager;
        this.encodedContentProvider = encodedContentProvider;
    }

    @Override
    public String getDisplayRevision(String revision) {
        return revision;
    }

    public abstract boolean isAvailableGivenLicense(LicenseInfo var1);

    public List<Pair<Path, List<CrucibleRevision>>> groupFileRevisions(Collection<CrucibleRevision> revisions) {
        if (revisions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CrucibleRevision> sortedRevisions = new ArrayList<CrucibleRevision>(revisions);
        Collections.sort(sortedRevisions, new BranchPathComparator());
        ArrayList<Pair<Path, List<CrucibleRevision>>> list = new ArrayList<Pair<Path, List<CrucibleRevision>>>();
        list.add(Pair.newInstance(sortedRevisions.get(0).getFePath(), new ArrayList()));
        ((List)((Pair)list.get(0)).getSecond()).add(sortedRevisions.get(0));
        for (int i2 = 1; i2 < sortedRevisions.size(); ++i2) {
            if (this.comparePathCongruence(sortedRevisions.get(i2 - 1), sortedRevisions.get(i2)) != 0) {
                Path p2 = sortedRevisions.get(i2).getFePath();
                list.add(Pair.newInstance(p2, new ArrayList()));
            }
            ((List)((Pair)list.get(list.size() - 1)).getSecond()).add(sortedRevisions.get(i2));
        }
        return list;
    }

    public int compareFileRevisions(CrucibleRevision dfr1, CrucibleRevision dfr2) throws SourceException {
        int result = this.comparePathCongruence(dfr1, dfr2);
        if (result == 0) {
            if (this.isBefore(dfr1.getRevInfoKey(), dfr2.getRevInfoKey())) {
                return -1;
            }
            if (this.isBefore(dfr2.getRevInfoKey(), dfr1.getRevInfoKey())) {
                return 1;
            }
        }
        return result;
    }

    public int comparePathCongruence(CrucibleRevision dfr1, CrucibleRevision dfr2) {
        return dfr1.getFePath().compareTo(dfr2.getFePath());
    }

    public String getName() {
        return this.sourceName;
    }

    public abstract String getChangeSetId(CrucibleRevision var1) throws SourceException;

    public String getReason() {
        return this.reason;
    }

    public SourceException getException() {
        return new SourceException(this.reason);
    }

    public abstract boolean isAvailable();

    public abstract boolean isAuthorized();

    public List<RepositorySource.AncestorAnnotationDO> getFullAnnotatedHistory(FileRevisionExtraInfo frx) throws SourceException {
        return null;
    }

    public abstract boolean isAnySuccessorRevisions(CrucibleRevision var1);

    public abstract String getLatestRevIdent(CrucibleRevision var1);

    public DiffPrinter getDiffPrinter(ContentManager contentManager, FileRevisionExtraInfo frx, CrucibleRevision fromFr, CrucibleRevision toFr, String keywordOpts, DiffOpts diffOpts, int context) throws Exception {
        DiffExplorer explorer = DiffHelper.getDiffExp(contentManager, this, frx, fromFr, toFr, keywordOpts, diffOpts, context);
        return explorer == null ? null : explorer.getPrinter();
    }

    public HunkList getHunkList(ContentManager contentManager, FileRevisionExtraInfo frx, CrucibleRevision fromFr, CrucibleRevision toFr, String keywordOpts, DiffOpts diffOpts, int context) throws Exception {
        return DiffHelper.getHunkList(contentManager, this, frx, fromFr, toFr, keywordOpts, diffOpts, context);
    }

    public abstract IndexedLineReader getFileContents(CrucibleRevision var1, String var2, Disposer var3) throws Exception;

    public IndexedLineReader getCachedEncodedFileContents(CrucibleRevision toRev, Disposer disposer) throws Exception {
        return this.encodedContentProvider.getCachedEncodedFileContents(toRev, this, disposer);
    }

    public abstract void copyFile(CrucibleRevision var1, File var2) throws Exception;

    public abstract Linker getLinker();

    public abstract List<String> findAuthors(Path var1);

    public abstract boolean isAllowsAuthorConstraint();

    public abstract List<String> findBranches(Path var1);

    public Set<String> getAllBranches() {
        return new HashSet<String>(this.findBranches(Path.ROOT));
    }

    public abstract String getDefaultBranch();

    public abstract boolean isAllowsBranchConstraint();

    public abstract SearchManager getSearchManager();

    public abstract ChangelogExplorer getChangelogExplorer(Path var1, WaybackSpec var2, Review var3);

    public abstract FileHistoryExplorer getFileHistoryExplorer(RevInfoKey var1, WaybackSpec var2);

    public abstract CrucibleChangeSet getChangeSet(String var1, boolean var2) throws SourceException, ChangeSetContentTooLargeException;

    public CrucibleChangeSet getChangeSet(String csid) throws SourceException, ChangeSetContentTooLargeException {
        return this.getChangeSet(csid, true);
    }

    public int getChangeSetRevisionCount(String csid) throws SourceException, ChangeSetContentTooLargeException {
        CrucibleChangeSet changeSet = this.getChangeSet(csid);
        return null == changeSet ? 0 : changeSet.getRevisions().size();
    }

    public boolean existsChangeSet(String csid) throws SourceException {
        try {
            return this.getChangeSet(csid) != null;
        }
        catch (ChangeSetContentTooLargeException e2) {
            return false;
        }
    }

    public abstract boolean isAfter(RevInfoKey var1, RevInfoKey var2) throws SourceException;

    public abstract boolean isBefore(RevInfoKey var1, RevInfoKey var2) throws SourceException;

    public abstract boolean isOnAncestryLine(List<CrucibleRevision> var1, CrucibleRevision var2, CrucibleRevision var3) throws SourceException;

    public abstract int getInsertIndex(List<CrucibleRevision> var1, CrucibleRevision var2, CrucibleRevision var3) throws SourceException;

    protected void validateRevisionSource(CrucibleRevision rev) throws SourceException {
        if (!this.getName().equals(rev.getSourceName())) {
            throw new SourceException("Invalid source. " + this.getName() + " does not equal " + rev.getSourceName());
        }
    }

    public abstract boolean isFile(Path var1) throws SourceException;

    public abstract boolean isDir(Path var1) throws SourceException;

    public abstract RepositoryExplorer getRepositoryExplorer(Path var1, WaybackSpec var2, CookiePreferences var3);

    public abstract boolean isChangesetCapable();

    public boolean isDirectoryBrowseCapable() {
        return true;
    }

    public abstract boolean isSearchCapable();

    public abstract boolean isStorable();

    public abstract FileRevisionInfo getFileRevisionInfo(String var1, String var2) throws FileRevisionException;

    public abstract RevInfoKey searchAncestors(RevInfoKey var1, Predicate<RevInfoKey> var2) throws FileRevisionException;

    public ReviewCreationHelper createReviewCreationHelper(Review review) {
        try {
            return new ReviewCreationHelper(this, review, this.contentManager, this.notificationManager, SpringContext.getComponentByClass(SPIUtils.class), this.commentManager, SpringContext.getComponentByClass(EventPublisher.class));
        }
        catch (SourceException e2) {
            throw new RuntimeException("error creating ReviewCreationHelper", e2);
        }
    }

    public abstract Charset getTextEncoding(CrucibleRevision var1) throws SourceException;

    public abstract String getDisplayName();

    public boolean isSupportsBranchFilter() {
        if (this instanceof RepositorySource) {
            return ((RepositorySource)this).getRepositoryHandle().getCfg().isSupportsBranchFilter();
        }
        return false;
    }

    class BranchPathComparator
    implements Comparator<CrucibleRevision> {
        BranchPathComparator() {
        }

        @Override
        public int compare(CrucibleRevision dfr1, CrucibleRevision dfr2) {
            try {
                return Source.this.compareFileRevisions(dfr1, dfr2);
            }
            catch (SourceException se) {
                throw new RuntimeException("Unable to compare revisions.", se);
            }
        }
    }

    static class SourceNameComparator
    implements Comparator<Source> {
        SourceNameComparator() {
        }

        @Override
        public int compare(Source o1, Source o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

