/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.crucible.explorers.RepositoryChangelogExplorer;
import com.atlassian.crucible.explorers.RepositoryFileHistoryExplorer;
import com.atlassian.crucible.explorers.RepositoryRepositoryExplorer;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.ChangesetReviewState;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.AndClause;
import com.cenqua.fisheye.search.query.CsidExactMatchClause;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.NotClause;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.search.query.ReviewClause;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FisheyeChangelogExplorer;
import com.cenqua.fisheye.web.FisheyeFileHistoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RepositorySource
extends Source {
    private final boolean authorized;
    private final RepositoryHandle rh;
    private final RepositoryEngine engine;
    private CommitterUserMappingManager committerUserMappingManager;

    public RepositorySource(String sourceName, Principal user, ContentManager contentManager, NotificationManager notificationManager, CommentManager commentManager, EncodedContentProvider encodedContentProvider, CommitterUserMappingManager committerUserMappingManager) {
        super(sourceName, contentManager, notificationManager, commentManager, encodedContentProvider);
        this.committerUserMappingManager = committerUserMappingManager;
        RepositoryEngine engine = null;
        String reason = "";
        boolean authorized = false;
        Preconditions.checkNotNull((Object)sourceName, (Object)"sourceName must not be null");
        this.rh = AppConfig.getsConfig().getRepositoryManager().getRepository(sourceName);
        if (this.rh == null) {
            reason = "Repository " + sourceName + " does not exist";
        } else {
            UserManager feum = AppConfig.getsConfig().getUserManager();
            authorized = feum.hasPermissionToAccess(user, this.rh);
            if (!authorized) {
                reason = "You are not authorized to access this repository";
            } else if (this.rh.isRunning()) {
                try {
                    engine = this.rh.acquireEngine();
                }
                catch (RepositoryHandle.StateException e2) {
                    Logs.APP_LOG.error((Object)"Exception", (Throwable)((Object)e2));
                    reason = e2.getMessage();
                }
            } else {
                reason = "Repository " + sourceName + " is not running.";
            }
        }
        this.engine = engine;
        this.authorized = authorized;
        this.reason = reason;
    }

    @Override
    public boolean isAvailableGivenLicense(LicenseInfo license) {
        return this.rh != null && (license.isFishEye() || license.isCrucible());
    }

    @Override
    public boolean isAuthorized() {
        return this.authorized;
    }

    @Override
    public boolean isAvailable() {
        return this.getRepoEngine() != null && this.getRepoEngine().getStatus() != null;
    }

    @Nullable
    public RepositoryHandle getRepositoryHandle() {
        return this.rh;
    }

    @Nullable
    public RepositoryEngine getRepoEngine() {
        return this.engine;
    }

    @Override
    public int comparePathCongruence(CrucibleRevision dfr1, CrucibleRevision dfr2) {
        int path = super.comparePathCongruence(dfr1, dfr2);
        if (path == 0) {
            return this.compareBranch(dfr1, dfr2);
        }
        return path;
    }

    private int compareBranch(CrucibleRevision dfr1, CrucibleRevision dfr2) {
        try {
            FileRevision fr1 = this.getFeFileRevision(dfr1);
            FileRevision fr2 = this.getFeFileRevision(dfr2);
            if (fr1 == fr2) {
                return 0;
            }
            if (fr1.getBranch() != null && fr2.getBranch() != null) {
                return fr1.getBranch().compareTo(fr2.getBranch());
            }
            return fr1.getBranch() == null ? -1 : 1;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Unable to retrieve FileRevision", (Throwable)e2);
            return 0;
        }
    }

    @Override
    public Charset getTextEncoding(CrucibleRevision cruRev) throws SourceException {
        Charset charset;
        if (this.isAvailable()) {
            try {
                charset = this.getRepoEngine().getRevisionCache().getTextEncoding(cruRev.getRevInfoKey());
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Unexpected problem getting charset", (Throwable)e2);
                throw new SourceException(e2);
            }
        } else {
            Logs.APP_LOG.warn((Object)("Unexpected problem getting charset " + this.getReason()));
            throw new SourceException(this.getReason());
        }
        return charset;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate) throws FileRevisionException {
        try {
            return this.getRepoEngine().getRevisionCache().searchAncestors(revInfoKey, predicate);
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Unexpected problem while searching predecessors of " + revInfoKey), (Throwable)e2);
            throw new FileRevisionException(e2);
        }
    }

    private FileRevision getFeFileRevision(CrucibleRevision crucibleRevision) throws FileRevisionException {
        return this.getFeFileRevision(crucibleRevision.getRevInfoKey());
    }

    public FileRevision getFeFileRevision(RevInfoKey key) throws FileRevisionException {
        FileRevision feFileRevision;
        if (this.isAvailable()) {
            try {
                feFileRevision = this.getRepoEngine().getRevisionCache().getFileRevision(key);
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Unexpected problem getting fe revision", (Throwable)e2);
                throw new FileRevisionException(e2);
            }
        } else {
            Logs.APP_LOG.warn((Object)("Unexpected problem getting fe revision " + this.getReason()));
            throw new FileRevisionException(this.getReason());
        }
        return feFileRevision;
    }

    @Override
    public String getChangeSetId(CrucibleRevision crucibleRevision) throws SourceException {
        try {
            FileRevision fr = this.getFeFileRevision(crucibleRevision);
            return fr == null ? null : fr.getChangeSetId();
        }
        catch (FileRevisionException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)e2);
            throw new SourceException("Error getting changeset for revision.", e2);
        }
    }

    @Override
    public CrucibleChangeSet getChangeSet(String csid, boolean noSizeCheck) throws SourceException, ChangeSetContentTooLargeException {
        try {
            Object cs = this.getRepoEngine().getRevisionCache().getChangeSet(csid);
            if (cs == null) {
                return null;
            }
            List<? extends FileRevision> fileRevisions = cs.getFileRevisions();
            if (!noSizeCheck && fileRevisions.size() > CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT) {
                throw new ChangeSetContentTooLargeException(CrucibleSysProps.REVIEW_CONTENT_SIZE_LIMIT);
            }
            ArrayList<FileRevision> changesetRevs = new ArrayList<FileRevision>(fileRevisions);
            List<CrucibleRevision> crucRevs = this.createCrucibleFileRevisions(changesetRevs);
            return new CrucibleChangeSet(csid, cs.getDisplayId(), crucRevs, cs.getComment(), cs.getDateValue(), cs.getAuthor(), this);
        }
        catch (DbException e2) {
            throw new SourceException("Error getting changeset for " + csid, e2);
        }
    }

    @Override
    public int getChangeSetRevisionCount(String csid) throws SourceException {
        try {
            Object cs = this.getRepoEngine().getRevisionCache().getChangeSet(csid);
            if (cs == null) {
                return 0;
            }
            return cs.getRevisionInfosCount();
        }
        catch (DbException e2) {
            throw new SourceException("Error getting changeset for " + csid, e2);
        }
    }

    @Override
    public boolean existsChangeSet(String csid) throws SourceException {
        try {
            return this.getRepoEngine().getRevisionCache().existsChangeSet(csid);
        }
        catch (DbException e2) {
            throw new SourceException("Error getting changeset for " + csid, e2);
        }
    }

    @Override
    public boolean isAfter(RevInfoKey thisRevIdent, RevInfoKey thatRevIdent) throws SourceException {
        return this.isBeforeAfter(thisRevIdent, thatRevIdent, false);
    }

    @Override
    public boolean isBefore(RevInfoKey thisRevIdent, RevInfoKey thatRevIdent) throws SourceException {
        return this.isBeforeAfter(thisRevIdent, thatRevIdent, true);
    }

    private boolean isBeforeAfter(RevInfoKey thisRevKey, RevInfoKey thatRevKey, boolean before) throws SourceException {
        try {
            FileRevision thisRev = this.getRepoEngine().getRevisionCache().getFileRevision(thisRevKey);
            FileRevision thatRev = this.getRepoEngine().getRevisionCache().getFileRevision(thatRevKey);
            if (thisRev == null) {
                throw new NullPointerException("Couldn't find this revision with key " + thisRevKey + " in repository " + this.getRepoEngine().getName());
            }
            if (thatRev == null) {
                throw new NullPointerException("Couldn't find that revision with key " + thatRevKey + " in repository " + this.getRepoEngine().getName());
            }
            return before ? this.getRepoEngine().getRevisionCache().isBefore(thisRev.getRevID(), thatRev.getRevID()) : this.getRepoEngine().getRevisionCache().isAfter(thisRev.getRevID(), thatRev.getRevID());
        }
        catch (DbException e2) {
            throw new SourceException("Error comparing revisions " + thisRevKey + " and " + thatRevKey, e2);
        }
    }

    @Override
    public boolean isOnAncestryLine(List<CrucibleRevision> existingRevisions, CrucibleRevision from, CrucibleRevision to) throws SourceException {
        boolean sharePath = false;
        for (CrucibleRevision rev : existingRevisions) {
            Path toPath;
            Path revPath = rev.getFePath();
            Path fromPath = from == null ? null : from.getFePath();
            Path path = toPath = to == null ? null : to.getFePath();
            if (!revPath.equals(fromPath) && !revPath.equals(toPath)) continue;
            sharePath = true;
            break;
        }
        if (!sharePath) {
            return false;
        }
        boolean fromIsOnLine = from == null || from.getId().equals(to.getId());
        boolean toIsOnLine = false;
        CrucibleRevision current = existingRevisions.get(0);
        if (from != null) {
            fromIsOnLine |= current.getId().equals(from.getId()) || this.isBefore(from.getRevInfoKey(), current.getRevInfoKey());
        }
        toIsOnLine |= current.getId().equals(to.getId()) || this.isBefore(to.getRevInfoKey(), current.getRevInfoKey());
        for (int i2 = 0; !(i2 >= existingRevisions.size() || toIsOnLine && fromIsOnLine); ++i2) {
            current = existingRevisions.get(i2);
            if (existingRevisions.size() <= i2 + 1) {
                if (from != null) {
                    fromIsOnLine |= current.getId().equals(from.getId()) || this.isAfter(from.getRevInfoKey(), current.getRevInfoKey());
                }
                toIsOnLine |= current.getId().equals(to.getId()) || this.isAfter(to.getRevInfoKey(), current.getRevInfoKey());
                continue;
            }
            CrucibleRevision next = existingRevisions.get(i2 + 1);
            if (from != null) {
                fromIsOnLine |= current.getId().equals(from.getId()) || this.isAfter(from.getRevInfoKey(), current.getRevInfoKey()) && this.isBefore(from.getRevInfoKey(), next.getRevInfoKey());
            }
            toIsOnLine |= current.getId().equals(to.getId()) || this.isAfter(to.getRevInfoKey(), current.getRevInfoKey()) && this.isBefore(to.getRevInfoKey(), next.getRevInfoKey());
        }
        return fromIsOnLine && toIsOnLine;
    }

    @Override
    public int getInsertIndex(List<CrucibleRevision> existingRevisions, CrucibleRevision fr, CrucibleRevision knownMax) throws SourceException {
        this.validateRevisionSource(fr);
        if (!existingRevisions.contains(fr)) {
            boolean needsAdd = true;
            int i2 = 0;
            for (CrucibleRevision currentRev : existingRevisions) {
                this.validateRevisionSource(currentRev);
                if (this.isBefore(fr.getRevInfoKey(), currentRev.getRevInfoKey()) || currentRev.equals(knownMax)) break;
                if (fr.getRevInfoKey().equals(currentRev.getRevInfoKey())) {
                    needsAdd = false;
                    break;
                }
                ++i2;
            }
            if (needsAdd) {
                return i2;
            }
        }
        return -1;
    }

    @Override
    public boolean isFile(Path path) throws SourceException {
        try {
            return this.getRepoEngine().getRevisionCache().isFile(path);
        }
        catch (DbException e2) {
            throw new SourceException("Error accessing repository for " + path, e2);
        }
    }

    @Override
    public boolean isDir(Path path) throws SourceException {
        try {
            return this.getRepoEngine().getRevisionCache().isDir(path);
        }
        catch (DbException e2) {
            throw new SourceException("Error accessing repository for " + path, e2);
        }
    }

    @Override
    public RepositoryExplorer getRepositoryExplorer(Path lpath, WaybackSpec wbSpec, CookiePreferences userPreferences) {
        try {
            return new RepositoryRepositoryExplorer(this.contentManager, this, this.getRepoEngine(), lpath, wbSpec, userPreferences);
        }
        catch (DbException e2) {
            throw new RuntimeException("Error creating repository explorer", e2);
        }
    }

    @Override
    public boolean isChangesetCapable() {
        return true;
    }

    @Override
    public boolean isSearchCapable() {
        return true;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    private FileRevision getFileRevision(String path, String revision) throws FileRevisionException {
        FileRevision fr = this.getFeFileRevision(new RevInfoKey(new Path(path), revision));
        if (fr == null) {
            throw new FileRevisionException("Can't find revision for " + path + " " + revision);
        }
        return fr;
    }

    @Override
    public FileRevisionInfo getFileRevisionInfo(String path, String revision) throws FileRevisionException {
        return this.getFileRevisionInfo(this.getFileRevision(path, revision));
    }

    public FileRevisionInfo getFileRevisionInfo(FileRevision fr) {
        FileRevisionInfo fri = new FileRevisionInfo(fr.getBranch(), fr.getDiffRevision(), fr.getRevision(), fr.getDisplayRevision(), fr.getAuthor(), fr.getPath().getPath(), new Date(fr.getDate()), fr.getComment(), fr.isDead(), fr.isBinary(), fr.isDir(), fr.isAnnotatable(), fr.isAdded(), fr.isModify(), fr.isMove(), fr.isCopy(), fr.getLinesAdded(), fr.getLinesRemoved(), fr.isOversize());
        fri.getDetails().put("changeset", fr.getChangeSetId());
        fri.getDetails().put("revisionLink", this.getRepoEngine().getLink(fr.getRevInfoKey()));
        return fri;
    }

    private List<CrucibleRevision> createCrucibleFileRevisions(List<FileRevision> ffrs) {
        ArrayList<FileRevisionInfo> fris = new ArrayList<FileRevisionInfo>(ffrs.size());
        for (FileRevision fr : ffrs) {
            fris.add(this.getFileRevisionInfo(fr));
        }
        return this.contentManager.makeCrucibleRevisions(this, fris);
    }

    @Override
    public boolean isAnySuccessorRevisions(CrucibleRevision currentRevision) {
        return !this.getLatestRevIdent(currentRevision).equals(currentRevision.getRevision());
    }

    @Override
    public String getLatestRevIdent(CrucibleRevision currentRevision) {
        RepositoryEngine repEngine = this.getRepoEngine();
        try {
            if (repEngine != null) {
                RevisionCache<? extends ChangeSet> revCache = repEngine.getRevisionCache();
                FileRevision current = this.getFeFileRevision(currentRevision);
                if (current == null) {
                    Logs.APP_LOG.warn((Object)("FishEye Revision for " + currentRevision.toString() + " is not available"));
                    return currentRevision.getRevision();
                }
                int last = revCache.findLastSuccessor(current.getRevID());
                Logs.APP_LOG.debug((Object)("last revid:" + last + " currentRevIdent:" + currentRevision.getRevision()));
                return revCache.getFileRevision(last).getRevision();
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Database error while getting latest revision. ", (Throwable)e2);
        }
        catch (FileRevisionException e3) {
            Logs.APP_LOG.error((Object)"Problem finding own revision.", (Throwable)e3);
        }
        return currentRevision.getRevision();
    }

    public RevInfoKey getLatestRevInfoKey(CrucibleRevision currentRevision) {
        RepositoryEngine repEngine = this.getRepoEngine();
        try {
            if (repEngine != null) {
                RevisionCache<? extends ChangeSet> revCache = repEngine.getRevisionCache();
                FileRevision current = this.getFeFileRevision(currentRevision);
                if (current == null) {
                    Logs.APP_LOG.warn((Object)("FishEye Revision for " + currentRevision.toString() + " is not available"));
                    return currentRevision.getRevInfoKey();
                }
                int last = revCache.findLastSuccessor(current.getRevID());
                Logs.APP_LOG.debug((Object)("last revid:" + last + " currentRevIdent:" + currentRevision.getRevision()));
                return revCache.getFileRevision(last).getRevInfoKey();
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Database error while getting latest revision. ", (Throwable)e2);
        }
        catch (FileRevisionException e3) {
            Logs.APP_LOG.error((Object)"Problem finding own revision.", (Throwable)e3);
        }
        return currentRevision.getRevInfoKey();
    }

    @Override
    public IndexedLineReader getFileContents(CrucibleRevision crucibleRevision, String kopts, Disposer disposer) throws Exception {
        RevisionCache<? extends ChangeSet> rc = this.getRepoEngine().getRevisionCache();
        FileRevision toRev = this.getFeFileRevision(crucibleRevision);
        if (toRev == null) {
            throw new PathNotFoundException("File not found while getting Contents ", this.getRepoEngine().getName(), crucibleRevision.getRevInfoKey());
        }
        return rc.getUnicodeTextRevision(toRev, kopts, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(CrucibleRevision crucibleRevision, File file) throws Exception {
        RevisionCache<? extends ChangeSet> rc = this.getRepoEngine().getRevisionCache();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            rc.getBinaryRevision(crucibleRevision.getRevInfoKey(), out);
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
    }

    @Override
    public Linker getLinker() {
        return this.getRepositoryHandle() == null ? AppConfig.getsConfig().getDefaultLinker() : this.getRepositoryHandle().getCfg().getLinker();
    }

    @Override
    public List<String> findAuthors(Path path) {
        try {
            return this.getRepoEngine().getRevisionCache().findAuthors(path);
        }
        catch (DbException e2) {
            throw new RuntimeException("Error getting authors", e2);
        }
    }

    @Override
    public boolean isAllowsAuthorConstraint() {
        return true;
    }

    @Override
    public List<String> findBranches(Path path) {
        try {
            return this.getRepoEngine().getRevisionCache().findBranches(path);
        }
        catch (DbException e2) {
            throw new RuntimeException("Error getting branches", e2);
        }
    }

    @Override
    public Set<String> getAllBranches() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.getRepoEngine().getRevisionCache().getBranches(), Branch.NOT_REMOVED), Branch.TO_NAME));
    }

    @Override
    @Nullable
    public String getDefaultBranch() {
        return this.getRepoEngine().getRevisionCache().getDefaultBranch();
    }

    @Override
    public boolean isAllowsBranchConstraint() {
        return true;
    }

    @Override
    public SearchManager getSearchManager() {
        return this.getRepoEngine().getSearchManager();
    }

    public FileRevision getFileRevision(int revId) {
        try {
            return this.getRepoEngine().getRevisionCache().getFileRevision(revId);
        }
        catch (DbException e2) {
            throw new RuntimeException("Error getting revision " + revId, e2);
        }
    }

    @Override
    public ChangelogExplorer getChangelogExplorer(Path path, WaybackSpec wbSpec, Review review) {
        RevisionCache<? extends ChangeSet> cache = this.getRepoEngine().getRevisionCache();
        try {
            return new RepositoryChangelogExplorer(this, new FisheyeChangelogExplorer(path, cache, wbSpec), review, this.committerUserMappingManager);
        }
        catch (DbException e2) {
            throw new RuntimeException("Error creating change log explorer", e2);
        }
    }

    @Override
    public FileHistoryExplorer getFileHistoryExplorer(RevInfoKey revInfoKey, WaybackSpec wb) {
        try {
            FileHistory fh = this.getRepoEngine().getRevisionCache().getFullFileHistory(revInfoKey.getPath());
            return new RepositoryFileHistoryExplorer(new FisheyeFileHistoryExplorer(fh, wb));
        }
        catch (DbException e2) {
            throw new RuntimeException("Error creating file history explorer", e2);
        }
    }

    @Override
    public String getDisplayRevision(String revision) {
        return this.getRepoEngine().getDisplayRevision(revision);
    }

    public Pair<Integer, Map<Path, Integer>> getRootPaths(Patch patch) throws DbException, IOException {
        return this.getRootPaths(patch, null);
    }

    public Pair<Integer, Map<Path, Integer>> getRootPaths(Patch patch, EggTimer eggTimer) throws DbException, IOException {
        HashSet<Path> patchPaths = new HashSet<Path>();
        for (CrucibleRevision fr : patch.getFileRevisions()) {
            if (fr.isAdded().booleanValue() || fr.isMoved().booleanValue() || fr.isCopied().booleanValue() || fr.isDeletion().booleanValue()) continue;
            patchPaths.add(fr.getFePath());
        }
        if (patchPaths.isEmpty()) {
            return Pair.newInstance(0, Collections.emptyMap());
        }
        RevisionCache<? extends ChangeSet> cache = this.getRepoEngine().getRevisionCache();
        Map<Path, Integer> roots = null;
        int stripCount = 0;
        block1: while (roots == null || roots.size() == 0) {
            roots = cache.findPathRoots(patchPaths, eggTimer);
            if (eggTimer != null && eggTimer.isTimeExpired()) break;
            if (roots.size() != 0) continue;
            ++stripCount;
            HashSet<Path> tmpPatchPaths = new HashSet<Path>();
            for (Path path : patchPaths) {
                if (path.isRoot()) break block1;
                tmpPatchPaths.add(path.getTailPath());
            }
            patchPaths = tmpPatchPaths;
        }
        return Pair.newInstance(stripCount, roots);
    }

    public ChangesetReviewState getChangesetReviewState(String csid, String permaid) throws Exception {
        FishQuery inReviewQuery = new FishQuery();
        FishQuery notInReviewQuery = new FishQuery();
        ReturnClause returnClause = new ReturnClause();
        returnClause.addField(new ReturnClause.CountRevisionsField());
        inReviewQuery.setReturnClause(returnClause);
        notInReviewQuery.setReturnClause(returnClause);
        CsidExactMatchClause cs = new CsidExactMatchClause(csid);
        ReviewClause inReviewClause = new ReviewClause(true, false, permaid, EnumSet.allOf(StateManager.MetaState.class));
        AndClause and = new AndClause();
        and.addClause(cs);
        and.addClause(inReviewClause);
        inReviewQuery.setWhereClause(and);
        NotClause notInReviewClause = new NotClause(inReviewClause);
        AndClause andNot = new AndClause();
        andNot.addClause(cs);
        andNot.addClause(notInReviewClause);
        notInReviewQuery.setWhereClause(andNot);
        SearchResults inReviewResults = this.engine.getSearchManager().runQuery(inReviewQuery, true);
        SearchResults notInReviewResults = this.engine.getSearchManager().runQuery(notInReviewQuery, true);
        int inReview = inReviewResults.getRevisionCount();
        int notInReview = notInReviewResults.getRevisionCount();
        if (inReview > 0 && notInReview == 0) {
            return ChangesetReviewState.FULL;
        }
        if (inReview > 0 && notInReview > 0) {
            return ChangesetReviewState.PARTIAL;
        }
        return ChangesetReviewState.NONE;
    }

    public static class AncestorAnnotationDO {
        private final Integer crucibleRevisionId;
        private final String revision;
        private final String authorName;
        private final Date commitDate;
        private final boolean currentlySelected;
        private final List<Review> otherReviews;
        private final String revisionDisplayName;

        public AncestorAnnotationDO(Integer crucibleRevisionId, String revision, String revisionDisplayName, String authorName, Date commitDate, boolean currentlySelected, List<Review> otherReviews) {
            this.crucibleRevisionId = crucibleRevisionId;
            this.revision = revision;
            this.revisionDisplayName = revisionDisplayName;
            this.authorName = authorName;
            this.commitDate = commitDate;
            this.currentlySelected = currentlySelected;
            this.otherReviews = otherReviews;
        }

        public AncestorAnnotationDO(CrucibleRevision crucibleRevision, boolean currentlySelected, List<Review> reviews) {
            this.crucibleRevisionId = crucibleRevision.getId();
            this.revision = crucibleRevision.getRevision();
            this.revisionDisplayName = crucibleRevision.getRevisionDisplayName();
            this.authorName = crucibleRevision.getAuthorName();
            this.commitDate = crucibleRevision.getCommitDate();
            this.currentlySelected = currentlySelected;
            this.otherReviews = reviews;
        }

        public Integer getCrucibleRevisionId() {
            return this.crucibleRevisionId;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getRevisionDisplayName() {
            return this.revisionDisplayName;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public Date getCommitDate() {
            return this.commitDate;
        }

        public boolean isCurrentlySelected() {
            return this.currentlySelected;
        }

        public List<Review> getReviews() {
            return this.otherReviews;
        }

        public String getReviewsString() {
            StringBuffer buf = new StringBuffer();
            String sep = "";
            for (Review r2 : this.otherReviews) {
                buf.append(sep).append(r2.getPermaId());
                sep = " ";
            }
            return buf.toString();
        }
    }
}

