/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.atlassian.crucible.explorers.ChangelogExplorer;
import com.atlassian.crucible.explorers.CrucibleChangeSet;
import com.atlassian.crucible.explorers.FileHistoryExplorer;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.scm.RepositoryExplorer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchDiff;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.patchDiff.PatchSectionView;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.io.Utf16ERandomAccessIoStream;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PatchSource
extends Source {
    private static final Logger log = Logs.loggerFor(PatchSource.class);
    private final EffectiveUserProvider effectiveUserProvider;
    private final SourceFactory sourceFactory;
    private final PatchManager patchManager;
    private Map<Integer, PatchDiff> patchDiffCache = new HashMap<Integer, PatchDiff>();
    private Map<CrucibleRevision, CrucibleRevision> anchoredRevisions = new HashMap<CrucibleRevision, CrucibleRevision>();
    private Map<CrucibleRevision, Patch> filePatchCache = new HashMap<CrucibleRevision, Patch>();

    public PatchSource(String sourceName, ContentManager contentManager, NotificationManager notificationManager, CommentManager commentManager, EncodedContentProvider encodedContentProvider, EffectiveUserProvider effectiveUserProvider, SourceFactory sourceFactory, PatchManager patchManager) {
        super(sourceName, contentManager, notificationManager, commentManager, encodedContentProvider);
        this.sourceFactory = sourceFactory;
        this.effectiveUserProvider = effectiveUserProvider;
        this.patchManager = patchManager;
    }

    @Override
    public boolean isAvailableGivenLicense(LicenseInfo license) {
        return license.isCrucible();
    }

    public PatchDiff getDiff(FileRevisionExtraInfo frx) {
        return this.getDiff(frx.getFileRevision());
    }

    public PatchDiff getDiff(CrucibleRevision crucibleRevision) {
        if (!this.patchDiffCache.containsKey(crucibleRevision.getId())) {
            Patch patch = this.findPatch(crucibleRevision);
            SyntaxDefinition syntaxDefinition = AppConfig.getsConfig().getSyntaxDefinitions().getSyntaxDefinitionForFile(crucibleRevision.getFileName());
            this.patchDiffCache.put(crucibleRevision.getId(), new PatchDiff(crucibleRevision, patch, syntaxDefinition));
        }
        return this.patchDiffCache.get(crucibleRevision.getId());
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isAuthorized() {
        return true;
    }

    @Override
    public boolean isAnySuccessorRevisions(CrucibleRevision fr) {
        return false;
    }

    @Override
    public String getLatestRevIdent(CrucibleRevision fr) {
        return fr.getRevision();
    }

    @Override
    public String getChangeSetId(CrucibleRevision crucibleRevision) {
        Patch p2 = this.findPatch(crucibleRevision);
        return p2 == null ? null : p2.getId().toString();
    }

    @Override
    public HunkList getHunkList(ContentManager contentManager, FileRevisionExtraInfo frx, CrucibleRevision fromFr, CrucibleRevision toFr, String keywordOpts, DiffOpts diffOpts, int context) throws Exception {
        if (!this.hasFullContent(fromFr) || !this.hasFullContent(toFr)) {
            PatchDiff diff = this.getDiff(toFr);
            List<PatchSectionView> sects = diff.getSectionViews(-1);
            if (sects.size() != 1) {
                return null;
            }
            diff = this.getDiff(fromFr);
            sects = diff.getSectionViews(-1);
            if (sects.size() != 1) {
                return null;
            }
        }
        return super.getHunkList(contentManager, frx, fromFr, toFr, keywordOpts, diffOpts, context);
    }

    @Override
    public DiffPrinter getDiffPrinter(ContentManager contentManager, FileRevisionExtraInfo frx, CrucibleRevision fromFr, CrucibleRevision toFr, String keywordOpts, DiffOpts diffOpts, int context) throws Exception {
        if (this.hasFullContent(toFr)) {
            try {
                return super.getDiffPrinter(contentManager, frx, fromFr, toFr, keywordOpts, diffOpts, context);
            }
            catch (PatchException e2) {
                log.debug((Object)"Failed to get content for anchored patch", (Throwable)e2);
            }
        }
        return new DiffPrinter(new ArrayList<SectionView>(this.getDiff(toFr).getSectionViews(context)), new DiffInfo(this.getName(), fromFr == null ? null : fromFr.getFileName(), fromFr == null ? null : fromFr.getPath(), fromFr == null ? null : fromFr.getRevision(), toFr.getPath(), toFr.getRevision()), diffOpts);
    }

    public boolean hasFullContent(CrucibleRevision rev) throws IOException {
        return this.isAnchoredFRX(rev) || rev.isAdded() != false;
    }

    public boolean isAnchoredFRX(CrucibleRevision fr) throws IOException {
        return this.getFileAnchor(this.contentManager, fr) != null;
    }

    public Blame getBlame(CrucibleRevision toRevision, int lineCount) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexedLineReader applyPatchDiff(IndexedLineReader knownContent, PatchDiff diff, Disposer disposer) throws IOException, PatchException {
        File tmpFile = disposer.newDisposedTmpFile();
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Utf16ERandomAccessIoStream.UTF_16LE));
            int toOffset = 0;
            for (PatchSectionView patchSectionView : diff.getSectionViews(-1)) {
                String line;
                int catchUpLine;
                Section section = patchSectionView.getSection();
                int n2 = catchUpLine = section.getFromStart() != 0 ? section.getFromStart() : section.getToStart() + toOffset;
                while (knownContent.getLineNumber() < catchUpLine && (line = knownContent.readline()) != null) {
                    out.write(line);
                }
                for (int i2 = 0; i2 < section.getFromLength(); ++i2) {
                    String repositoryLine = StringUtils.chomp((String)knownContent.readline());
                    String patchLine = StringUtils.chomp((String)patchSectionView.getFromLine(section.getFromStart() + i2).toString());
                    if (repositoryLine != null && repositoryLine.equals(patchLine)) continue;
                    throw new PatchException("Patch did not apply cleanly to FishEye repository at line " + (section.getFromStart() + i2 + 1));
                }
                out.write(patchSectionView.getToLines().toString());
                toOffset += section.getFromLength() - section.getToLength();
            }
            String line = knownContent.readline();
            while (line != null) {
                out.write(line);
                line = knownContent.readline();
            }
        }
        catch (Throwable throwable) {
            IOHelper.close(out);
            throw throwable;
        }
        IOHelper.close(out);
        BufferedRandomAccessInputStream ris = new BufferedRandomAccessInputStream(tmpFile);
        StreamIndexedLineReader reader = new StreamIndexedLineReader(new Utf16ERandomAccessIoStream(ris));
        disposer.add(reader);
        return reader;
    }

    @Override
    public IndexedLineReader getFileContents(CrucibleRevision fr, String kopts, Disposer disposer) throws Exception {
        Source anchorSource;
        CrucibleRevision anchorRev = this.getFileAnchor(this.contentManager, fr);
        if (anchorRev != null && (anchorSource = this.getAnchoredSource(fr)) != null && anchorSource.isAvailable()) {
            PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(fr);
            if (patchRevision.isFrom) {
                return anchorSource.getFileContents(anchorRev, kopts, disposer);
            }
            IndexedLineReader anchorReader = anchorSource.getFileContents(anchorRev, kopts, disposer);
            return this.applyPatchDiff(anchorReader, this.getDiff(fr), disposer);
        }
        PatchDiff diff = this.getDiff(fr);
        List<PatchSectionView> sects = diff.getSectionViews(-1);
        if (sects.size() != 1) {
            throw new PatchException("Could not get contents for file.");
        }
        File tmpFile = disposer.newDisposedTmpFile();
        PatchSectionView view = sects.get(0);
        IOHelper.copyCharSequenceToFile(view.getToLines(), Utf16ERandomAccessIoStream.UTF_16LE, tmpFile);
        StreamIndexedLineReader reader = new StreamIndexedLineReader(new Utf16ERandomAccessIoStream(new BufferedRandomAccessInputStream(tmpFile)));
        disposer.add(reader);
        return reader;
    }

    public Source getAnchoredSource(CrucibleRevision fr) {
        return this.getAnchoredSource(this.findPatch(fr));
    }

    private Source getAnchoredSource(Patch p2) {
        String anchorSource = p2.getAnchorSource();
        return Strings.isNullOrEmpty((String)anchorSource) ? null : this.sourceFactory.getSource(anchorSource, this.effectiveUserProvider.getEffectivePrincipal());
    }

    public CrucibleRevision getFileAnchor(ContentManager contentManager, CrucibleRevision fr) throws IOException {
        if (!this.anchoredRevisions.containsKey(fr)) {
            this.anchoredRevisions.put(fr, this.getRevisionAnchor(contentManager, fr, true, this.getAnchoredSource(this.findPatch(fr))));
        }
        return this.anchoredRevisions.get(fr);
    }

    public CrucibleRevision getRevisionAnchor(ContentManager contentManager, CrucibleRevision fr, boolean from, Source anchorSource) throws IOException {
        try {
            Patch p2 = this.findPatch(fr);
            if (from && p2 != null && anchorSource != null && anchorSource.isAvailable()) {
                CrucibleRevision fromFr;
                DiffRevisionsInfo dri = p2.getDiffRevisionInfo(fr);
                CrucibleRevision crucibleRevision = fromFr = dri == null ? null : p2.getFromRevisionFromDRI(dri);
                if (fromFr != null) {
                    String anchorRevisionString = fromFr.getDetail("ANCHORED_REV");
                    String anchorPath = fromFr.getDetail("ANCHORED_PATH");
                    if (anchorRevisionString != null && anchorPath != null) {
                        CrucibleRevision anchorRevision = contentManager.getCrucibleRevision(anchorSource, anchorPath, anchorRevisionString);
                        return anchorRevision;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public boolean validateAnchorContent(Source anchorSource, CrucibleRevision fr, CrucibleRevision candidateAnchor) throws Exception {
        Disposer disposer = Disposer.threadInstance();
        if (candidateAnchor != null) {
            IndexedLineReader anchorReader = anchorSource.getFileContents(candidateAnchor, "", disposer);
            IndexedLineReader indexedLineReader = null;
            try {
                indexedLineReader = this.applyPatchDiff(anchorReader, this.getDiff(fr), disposer);
            }
            catch (PatchException e2) {
                log.debug((Object)"Anchor validation failed", (Throwable)e2);
            }
            return indexedLineReader != null;
        }
        return false;
    }

    private Patch findPatch(CrucibleRevision fr) {
        if (!this.filePatchCache.containsKey(fr)) {
            Patch p2 = this.patchManager.findPatch(fr);
            this.filePatchCache.put(fr, p2);
        }
        return this.filePatchCache.get(fr);
    }

    public String getAnchoredSourceName(CrucibleRevision fr) {
        Patch p2 = this.findPatch(fr);
        return p2.getAnchorSource();
    }

    @Override
    public void copyFile(CrucibleRevision revision, File file) throws Exception {
        Patch patch = this.findPatch(revision);
        if (patch != null) {
            UploadItem item = patch.getUploadItem();
            IOHelper.copy(item.getItemFile(), file);
        }
        throw new Exception("Could not get contents for file.");
    }

    @Override
    public Linker getLinker() {
        return AppConfig.getsConfig().getDefaultLinker();
    }

    @Override
    public List<String> findAuthors(Path path) {
        return null;
    }

    @Override
    public boolean isAllowsAuthorConstraint() {
        return false;
    }

    @Override
    public List<String> findBranches(Path path) {
        return null;
    }

    @Override
    public String getDefaultBranch() {
        return null;
    }

    @Override
    public boolean isAllowsBranchConstraint() {
        return false;
    }

    @Override
    public SearchManager getSearchManager() {
        return null;
    }

    @Override
    public ChangelogExplorer getChangelogExplorer(Path path, WaybackSpec wbSpec, Review review) {
        return null;
    }

    @Override
    public FileHistoryExplorer getFileHistoryExplorer(RevInfoKey revInfoKey, WaybackSpec wb) {
        return null;
    }

    @Override
    public CrucibleChangeSet getChangeSet(String csid, boolean noSizeCheck) {
        return null;
    }

    @Override
    public boolean isAfter(RevInfoKey thisRevisionIdent, RevInfoKey thatRevisionIdent) {
        return false;
    }

    @Override
    public boolean isBefore(RevInfoKey thisRevisionIdent, RevInfoKey thatRevisionIdent) {
        return false;
    }

    @Override
    public boolean isOnAncestryLine(List<CrucibleRevision> existingRevisions, CrucibleRevision from, CrucibleRevision to) throws SourceException {
        return false;
    }

    @Override
    public int getInsertIndex(List<CrucibleRevision> existingRevisions, CrucibleRevision fr, CrucibleRevision knownMax) throws SourceException {
        throw new SourceException("getInsertIndex() method not supported");
    }

    @Override
    public boolean isFile(Path path) {
        return false;
    }

    @Override
    public boolean isDir(Path path) {
        return false;
    }

    @Override
    public RepositoryExplorer getRepositoryExplorer(Path lpath, WaybackSpec wbSpec, CookiePreferences userPreferences) {
        return null;
    }

    @Override
    public boolean isChangesetCapable() {
        return false;
    }

    @Override
    public boolean isSearchCapable() {
        return false;
    }

    @Override
    public boolean isStorable() {
        return false;
    }

    @Override
    public FileRevisionInfo getFileRevisionInfo(String path, String revision) throws FileRevisionException {
        CrucibleRevision cruRev = FileRevisionManager.findRevision(this.getName(), path, revision);
        if (cruRev == null) {
            throw new FileRevisionException("Patch revision not found: " + path + " " + revision);
        }
        return this.getFileRevisionInfo(cruRev);
    }

    private FileRevisionInfo getFileRevisionInfo(CrucibleRevision cruRev) throws FileRevisionException {
        try {
            Patch p2 = this.findPatch(cruRev);
            DiffRevisionsInfo dri = p2.getDiffRevisionInfo(cruRev);
            boolean from = cruRev.getRevision().endsWith("F");
            Pair<Integer, Integer> lines = this.getLinesAddedRemoved(cruRev);
            return PatchSource.makeFileRevisionInfo(p2, dri, from, lines.getFirst(), lines.getSecond());
        }
        catch (IOException e2) {
            throw new FileRevisionException(e2);
        }
    }

    public static FileRevisionInfo makeFileRevisionInfo(Patch p2, DiffRevisionsInfo dri, boolean from, Integer linesAdded, Integer linesRemoved) {
        RevInfoKey diffRevision = from || dri.getFromRevisionName() == null ? null : new RevInfoKey(dri.getPath(), dri.getFromRevisionName());
        return new FileRevisionInfo(null, diffRevision, new PatchRevision(p2, dri, from).toString(), from ? dri.getFromRevisionName() : DiffRevisionsInfo.getToRevisionName(1), p2.getUploadItem().getUser().getUsername(), dri.getPath().getPath(), p2.getUploadItem().getCreateDate(), p2.getUploadItem().getDescription(), !from && dri.isDeleted(), false, false, true, !from && dri.isAdded(), !from && dri.isChanged(), !from && dri.isMoved(), !from && dri.isCopied(), linesAdded, linesRemoved, false);
    }

    public Pair<Integer, Integer> getLinesAddedRemoved(CrucibleRevision cruRev) throws FileRevisionException {
        try {
            PatchDiff diff = this.getDiff(cruRev);
            return diff.getLinesAddedRemoved();
        }
        catch (PatchException e2) {
            throw new FileRevisionException(e2);
        }
    }

    @Override
    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate) throws FileRevisionException {
        return null;
    }

    @Override
    public Charset getTextEncoding(CrucibleRevision fr) throws SourceException {
        return Charset.forName(fr.getUploadItem().getCharset());
    }

    @Override
    public String getDisplayName() {
        Iterable<Patch> patchesForSource = this.patchManager.getActivePatchesForSource(this.getName());
        int patchCount = Iterables.size(patchesForSource);
        if (patchCount == 0) {
            log.warn((Object)("Found no patches for patch source " + this.getName()));
            return "Patch";
        }
        Patch first = (Patch)Iterables.getFirst(patchesForSource, null);
        Patch last = (Patch)Iterables.getLast(patchesForSource, null);
        String firstPatchName = first.getUploadItem().getOriginalName();
        String lastPatchAge = " (" + DateHelper.age(last.getUploadItem().getCreateDateTime(), new Date().getTime()) + " ago)";
        String patchCountDesc = patchCount > 1 ? " - " + patchCount + " iterations" : "";
        return firstPatchName + lastPatchAge + patchCountDesc;
    }
}

