/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.google.common.base.Objects;

public class PatchRevision {
    private static final String FROM_MARKER = "F";
    private static final String TO_MARKER = "T";
    private static final String SEP = ":";
    public final int patchId;
    public final int driIndex;
    public final boolean isFrom;

    PatchRevision(int patchId, int driIndex, boolean from) {
        this.patchId = patchId;
        this.driIndex = driIndex;
        this.isFrom = from;
    }

    public PatchRevision(Patch patch, DiffRevisionsInfo dri, boolean from) {
        this(patch.getId(), dri.getIndex(), from);
    }

    public String toString() {
        return this.patchId + SEP + this.driIndex + SEP + (this.isFrom ? FROM_MARKER : TO_MARKER);
    }

    public static PatchRevision fromCrucibleRevision(CrucibleRevision revision) {
        return PatchRevision.fromCrucibleRevision(revision.getRevision());
    }

    public static PatchRevision fromCrucibleRevision(String revId) {
        String[] split = revId.split(SEP);
        if (split.length != 3 || !split[2].equals(FROM_MARKER) && !split[2].equals(TO_MARKER)) {
            throw new IllegalArgumentException("Not a patch revision id: " + revId);
        }
        return new PatchRevision(Integer.parseInt(split[0]), Integer.parseInt(split[1]), FROM_MARKER.equals(split[2]));
    }

    public PatchRevision getFromRevision() {
        return this.isFrom ? this : new PatchRevision(this.patchId, this.driIndex, true);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.patchId, this.driIndex, this.isFrom});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatchRevision other = (PatchRevision)obj;
        return Objects.equal((Object)this.patchId, (Object)other.patchId) && Objects.equal((Object)this.driIndex, (Object)other.driIndex) && Objects.equal((Object)this.isFrom, (Object)other.isFrom);
    }
}

