/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.atlassian.fisheye.scm.SCMSource;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.revision.source.UploadSource;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sourceFactory")
public class DefaultSourceFactory
implements SourceFactory {
    private SCMModuleManager scmModuleManager;
    private ContentManager contentManager;
    private NotificationManager notificationManager;
    private EffectiveUserProvider effectiveUserProvider;
    private EncodedContentProvider encodedContentProvider;
    @Resource
    private PatchManager patchManager;
    @Resource
    private CommentManager commentManager;
    @Resource
    private CommitterUserMappingManager committerUserMappingManager;

    @Autowired
    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public boolean sourceExists(String sourceName) {
        return this.scmModuleManager.getRepository(sourceName) != null || this.fisheyeSourceExists(sourceName);
    }

    private boolean fisheyeSourceExists(String sourceName) {
        return AppConfig.getsConfig().getRepositoryManager().getRepository(sourceName) != null;
    }

    @Override
    @Nullable
    public Source getSource(String sourceName, Principal user) {
        if (Strings.isNullOrEmpty((String)sourceName)) {
            return null;
        }
        Pair<String, Principal> key = Pair.newInstance(sourceName, user);
        Map<Pair<String, Principal>, Source> sourceCache = CrucibleFilter.getSourceCache();
        if (sourceCache == null) {
            return this.makeSource(sourceName, user);
        }
        Source source = sourceCache.get(key);
        if (source == null) {
            source = this.makeSource(sourceName, user);
            sourceCache.put(key, source);
        }
        return source;
    }

    @Override
    public PatchSource getPatchSource(int patchId) {
        return (PatchSource)this.getSource("PATCH:" + patchId, this.effectiveUserProvider.getEffectivePrincipal());
    }

    private Source makeSource(String sourceName, Principal user) {
        if (sourceName != null && sourceName.startsWith("PATCH:")) {
            return new PatchSource(sourceName, this.contentManager, this.notificationManager, this.commentManager, this.encodedContentProvider, this.effectiveUserProvider, this, this.patchManager);
        }
        if (sourceName != null && sourceName.startsWith("UPLOAD:")) {
            return new UploadSource(sourceName, this.contentManager, this.notificationManager, this.commentManager, this.encodedContentProvider);
        }
        SCMRepository repo = this.scmModuleManager.getRepository(sourceName);
        if (repo != null) {
            return this.makeSCMSource(repo, user);
        }
        return this.makeRepositorySource(sourceName, user);
    }

    private Source makeRepositorySource(String sourceName, Principal principal) {
        return new RepositorySource(sourceName, principal, this.contentManager, this.notificationManager, this.commentManager, this.encodedContentProvider, this.committerUserMappingManager);
    }

    private Source makeSCMSource(SCMRepository repo, Principal principal) {
        Pair<Principal, SCMRepository> key = Pair.newInstance(principal, repo);
        Map<Pair<Principal, SCMRepository>, SCMSource> scmSourceCache = CrucibleFilter.getSCMSourceCache();
        if (scmSourceCache == null) {
            return new SCMSource(repo, principal, this.contentManager, this.notificationManager, this.commentManager, this.encodedContentProvider, this.committerUserMappingManager);
        }
        SCMSource s2 = scmSourceCache.get(key);
        if (s2 == null) {
            s2 = new SCMSource(repo, principal, this.contentManager, this.notificationManager, this.commentManager, this.encodedContentProvider, this.committerUserMappingManager);
            scmSourceCache.put(key, s2);
        }
        return s2;
    }

    @Autowired
    public void setScmModuleManager(SCMModuleManager scmModuleManager) {
        this.scmModuleManager = scmModuleManager;
    }

    @Override
    public Collection<Source> getSources(Principal principal) {
        ArrayList<Source> sources = new ArrayList<Source>();
        sources.addAll(this.getFisheyeSources(principal));
        sources.addAll(this.getLightSCMSources(principal));
        Collections.sort(sources, Source.COMPARATOR);
        return sources;
    }

    private Collection<Source> getLightSCMSources(Principal principal) {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (SCMRepository repository : this.scmModuleManager.getRepositories()) {
            Source s2 = this.makeSCMSource(repository, principal);
            if (!this.isAvailableGivenLicense(s2)) continue;
            sources.add(s2);
        }
        return sources;
    }

    private Collection<Source> getFisheyeSources(Principal principal) {
        ArrayList<Source> sources = new ArrayList<Source>();
        for (RepositoryHandle rh : AppConfig.getsConfig().getRepositoryManager().getHandles()) {
            Source s2;
            if (!RepositoryUtil.hasPermission(principal, rh) || !this.isAvailableGivenLicense(s2 = this.makeRepositorySource(rh.getName(), principal))) continue;
            sources.add(s2);
        }
        return sources;
    }

    private boolean isAvailableGivenLicense(Source source) {
        return source.isAvailableGivenLicense(AppConfig.getsConfig().getLicense());
    }

    @Autowired
    public void setContentManager(ContentManager contentManager) {
        this.contentManager = contentManager;
    }

    @Override
    public boolean isPatchSource(Source source) {
        return source.getName().startsWith("PATCH:");
    }

    @Override
    public boolean isPatchSource(String sourceName) {
        return sourceName.startsWith("PATCH:");
    }

    @Autowired
    public void setEffectiveUserProvider(EffectiveUserProvider effectiveUserProvider) {
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Autowired
    public void setEncodedContentProvider(EncodedContentProvider encodedContentProvider) {
        this.encodedContentProvider = encodedContentProvider;
    }
}

