/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.managers;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.util.IdToPathMapper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.io.Utf16ERandomAccessIoStream;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Disposer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service(value="encodedContentProvider")
public class DefaultEncodedContentProvider
implements EncodedContentProvider {
    private final ConcurrentMap<String, Object> pathLocks = new ConcurrentHashMap<String, Object>();

    @PostConstruct
    public void clearCache() {
        Logs.APP_LOG.debug((Object)"Checking encoded content cache");
        File encodedCacheDir = this.getEncodedContentCacheDir();
        if (encodedCacheDir.exists()) {
            File newTrash;
            Logs.APP_LOG.debug((Object)"Clearing encoded content cache");
            File trashRoot = new File(AppConfig.getTempDir(), "encodedcontenttrash");
            File file = newTrash = trashRoot.isDirectory() ? new File(trashRoot, String.valueOf(System.currentTimeMillis())) : trashRoot;
            if (!encodedCacheDir.renameTo(newTrash)) {
                throw new IllegalStateException("Failed to move old encoded content directory");
            }
            Logs.APP_LOG.debug((Object)("Moved old encoded content cache to " + newTrash));
            this.deleteTrashInBackground(trashRoot);
        }
    }

    private void deleteTrashInBackground(final File trashRoot) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Encoded Content Cache Clearer");
                try {
                    Thread.currentThread().setPriority(1);
                }
                catch (Exception e2) {
                    Logs.APP_LOG.debug((Object)"Failed to lower cache clearing priority. This shouldn't be a problem.");
                }
                Logs.APP_LOG.debug((Object)("Deleting old cache trashes at: " + trashRoot.getAbsolutePath()));
                IOHelper.recursiveDelete(trashRoot, 8, true);
                Logs.APP_LOG.debug((Object)"Deleted old cache trashes");
            }
        });
        executorService.shutdown();
    }

    private File getEncodedContentCacheDir() {
        return new File(AppConfig.getTempDir(), "encodedcontent");
    }

    @Override
    public IndexedLineReader getContent(UploadItem uploadItem, Disposer disposer) throws IOException {
        File encodedItemFile = this.getEncodedFileForId(uploadItem.getId(), "uploaditem");
        this.createAndPopulateFileIfAbsent(encodedItemFile, new ExistingFileEncoder(uploadItem.getItemFile(), this.getCharset(uploadItem)));
        return this.getReaderForEncodedFile(encodedItemFile, disposer);
    }

    @Override
    public IndexedLineReader getCachedEncodedFileContents(CrucibleRevision cruRev, Source source, Disposer disposer) throws Exception {
        File cacheFile = this.getEncodedFileForId(cruRev.getId(), "crurev");
        this.createAndPopulateFileIfAbsent(cacheFile, new EncodedReaderCopier(cruRev, source, disposer));
        return this.getReaderForEncodedFile(cacheFile, disposer);
    }

    private Charset getCharset(UploadItem uploadItem) {
        if (uploadItem.getCharset() == null) {
            throw new IllegalStateException("Character set is not defined for uploadItem " + uploadItem.getOriginalName());
        }
        return Charset.forName(uploadItem.getCharset());
    }

    private File getEncodedFileForId(int id, String type) {
        File encodedCacheDir = this.getEncodedContentCacheDir();
        File dir = new File(new File(encodedCacheDir, type), IdToPathMapper.storageDirName(id));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Could not create encoded content cache directory: " + dir);
        }
        return new File(dir, id + ".dat");
    }

    private IndexedLineReader getReaderForEncodedFile(File encodedFile, Disposer disposer) throws FileNotFoundException {
        BufferedRandomAccessInputStream ris = new BufferedRandomAccessInputStream(encodedFile);
        StreamIndexedLineReader reader = new StreamIndexedLineReader(new Utf16ERandomAccessIoStream(ris));
        disposer.add(reader);
        return reader;
    }

    private Object getLockForPath(File encodedItemFile) {
        Object potentialLock = new Object();
        Object existingLock = this.pathLocks.putIfAbsent(encodedItemFile.getPath(), potentialLock);
        return existingLock != null ? existingLock : potentialLock;
    }

    private void clearLockForPath(File encodedItemFile) {
        this.pathLocks.remove(encodedItemFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void createAndPopulateFileIfAbsent(File file, ContentWriter<E> contentWriter) throws IOException, E {
        Object object = this.getLockForPath(file);
        synchronized (object) {
            try {
                if (file.exists()) {
                    return;
                }
                if (!file.createNewFile() && !file.exists()) {
                    throw new IllegalStateException("Create new file check failed. Possibly multiple crucible's running? File: " + file);
                }
                contentWriter.writeContent(file);
            }
            finally {
                this.clearLockForPath(file);
            }
        }
    }

    private static class ExistingFileEncoder
    implements ContentWriter<IOException> {
        private final File itemFile;
        private final Charset cs;

        public ExistingFileEncoder(File itemFile, Charset cs) {
            this.itemFile = itemFile;
            this.cs = cs;
        }

        @Override
        public void writeContent(File cacheFile) throws IOException {
            IOHelper.translateEncodings(this.itemFile, this.cs, cacheFile, Utf16ERandomAccessIoStream.UTF_16LE);
        }
    }

    private static class EncodedReaderCopier
    implements ContentWriter<Exception> {
        private final CrucibleRevision cruRev;
        private final Source source;
        private final Disposer disposer;

        public EncodedReaderCopier(CrucibleRevision cruRev, Source source, Disposer disposer) {
            this.cruRev = cruRev;
            this.source = source;
            this.disposer = disposer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeContent(File cacheFile) throws Exception {
            BufferedWriter out = null;
            try {
                IndexedLineReader inReader = this.getOriginalContent();
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), Utf16ERandomAccessIoStream.UTF_16LE));
                String readLine = inReader.readline();
                while (readLine != null) {
                    out.write(readLine);
                    readLine = inReader.readline();
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(out);
                throw throwable;
            }
            IOHelper.close(out);
        }

        private IndexedLineReader getOriginalContent() throws Exception {
            return this.source.getFileContents(this.cruRev, null, this.disposer);
        }
    }

    static interface ContentWriter<E extends Exception> {
        public void writeContent(File var1) throws E, IOException;
    }
}

