/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.managers;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.scm.SCMSource;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.CrucibleRevisionCreator;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StringIndexedLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@AvailableToPlugins
@Service(value="contentManager")
public class DefaultContentManager
implements ContentManager {
    private SourceFactory sourceFactory;
    private final ExecutorService updaters;
    private final Set<Integer> updateTracker = new HashSet<Integer>();
    private final UnreadManager unreadManager;
    private final UnreadFileManager unreadFileManager;
    private final UserProfileManager userProfileManager;
    private final UserManager userManager;
    private final EncodedContentProvider encodedContentProvider;
    private final TxTemplate txTemplate;
    private final CurrentSessionProvider currentSessionProvider;
    private final PatchManager patchManager;

    @Autowired
    public DefaultContentManager(UnreadManager unreadManager, UnreadFileManager unreadFileManager, UserProfileManager userProfileManager, UserManager userManager, EncodedContentProvider encodedContentProvider, TxTemplate txTemplate, CurrentSessionProvider currentSessionProvider, PatchManager patchManager) {
        this.unreadManager = unreadManager;
        this.unreadFileManager = unreadFileManager;
        this.userProfileManager = userProfileManager;
        this.userManager = userManager;
        this.encodedContentProvider = encodedContentProvider;
        this.txTemplate = txTemplate;
        this.currentSessionProvider = currentSessionProvider;
        this.patchManager = patchManager;
        this.updaters = Executors.newFixedThreadPool(1, new ConfigurableThreadFactory("ContentManagerUpdateThread", true));
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public FRXDO makeFRXDO(FileRevisionExtraInfo frx, FecruUser currentUser, Principal principal, CurrentUserPermissions currentUserPermissions, String keywordOpts, boolean sideBySide, boolean softWrap, boolean allowContentFetch) {
        if (frx.getFrxRevisions() == null || frx.getFrxRevisions().isEmpty()) {
            Logs.APP_LOG.warn((Object)("Cannot find any revisions in FRX with id \"" + frx.getId() + "\""));
            return null;
        }
        Source source = this.sourceFactory.getSource(frx.getFileRevision().getSourceName(), principal);
        this.checkFRX(frx, source);
        boolean displayable = frx.getFileRevision().isStored() || source.isAvailable();
        FRXDO frxdo = new FRXDO(this, this.unreadManager, this.unreadFileManager, this.getUserProfileManager(), frx, currentUser, principal, currentUserPermissions, keywordOpts, sideBySide, softWrap, this.sourceFactory, displayable, allowContentFetch);
        if (frxdo.getFrxRevisions().isEmpty()) {
            Logs.APP_LOG.warn((Object)("Cannot find any revisions in FRX with id \"" + frx.getId() + "\""));
            return null;
        }
        return frxdo;
    }

    public UserProfileManager getUserProfileManager() {
        return this.userProfileManager;
    }

    private void checkFRX(FileRevisionExtraInfo frx, Source source) {
        this.checkRevisionDetails(frx.getFileRevision(), source, false);
        if (frx.getFromRevision() != null) {
            this.checkRevisionDetails(frx.getFromRevision(), source, false);
        }
        this.fixNullFromOnPatchCopy(frx, source);
    }

    private void checkAndStoreContents(Project project, CrucibleRevision cruRev, Source source) {
        if (source.isAvailable() && source.isStorable() && project.isStoreRevisions() && !cruRev.isStored()) {
            this.tryStoreRevision(cruRev, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryStoreRevision(CrucibleRevision cruRev, Source source) {
        File file = null;
        try {
            file = File.createTempFile("crucible", null);
            if (cruRev.isDeletion() == null || !cruRev.isDeletion().booleanValue()) {
                source.copyFile(cruRev, file);
            }
            this.createUploadItem(cruRev, source, file);
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("Couldn't store revision " + cruRev), (Throwable)e2);
            boolean bl = false;
            return bl;
        }
        finally {
            IOHelper.deleteFile(file);
        }
    }

    private void createUploadItem(final CrucibleRevision cruRev, final Source source, final File file) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                FecruUser author = DefaultContentManager.this.userManager.getUser(cruRev.getAuthorName());
                UploadItem ui = UploadManager.createUploadItem(author, cruRev.getFileName(), file, DefaultContentManager.this.guessContentType(cruRev), "stored", DefaultContentManager.this.getTextEncoding(cruRev, source));
                cruRev.setUploadItem(ui);
                return null;
            }
        });
    }

    private String getTextEncoding(CrucibleRevision cruRev, Source source) throws SourceException {
        if (cruRev.isBinaryOrOversize()) {
            return null;
        }
        Charset cs = source.getTextEncoding(cruRev);
        return cs == null ? null : cs.name();
    }

    public String guessContentType(CrucibleRevision cruRev) {
        CustomFileNameMap fnm = AppConfig.getsConfig().getRawMimeMap();
        String guess = fnm.getContentTypeFor(cruRev.getFileName().toLowerCase(Locale.US));
        if (guess != null) {
            return guess.toLowerCase(Locale.US);
        }
        if (cruRev.isBinary() != null && cruRev.isBinary().booleanValue()) {
            return "application/octet-stream";
        }
        return "text/plain";
    }

    private void fixNullFromOnPatchCopy(FileRevisionExtraInfo frx, Source source) {
        if (frx.getFromRevision() == null && this.sourceFactory.isPatchSource(source) && DefaultContentManager.isTrue(frx.getFileRevision().isCopied())) {
            Patch p2 = this.patchManager.findPatch(frx.getFileRevision());
            try {
                this.patchManager.createFileRevisions(p2);
                CrucibleRevision cr = FileRevisionManager.findRevision(source.getName(), frx.getFileRevision().getPath(), PatchRevision.fromCrucibleRevision(frx.getFileRevision()).getFromRevision().toString());
                frx.addRevision(0, cr);
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Unable to update copy patch", (Throwable)e2);
            }
            catch (PatchException e3) {
                Logs.APP_LOG.error((Object)"Unable to update copy patch", (Throwable)e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevision(CrucibleRevision cruRev, Source source, boolean synchronous) {
        Set<Integer> set = this.updateTracker;
        synchronized (set) {
            if (!this.updateTracker.contains(cruRev.getId())) {
                this.updateTracker.add(cruRev.getId());
                this.updaters.submit(new Updater(source, cruRev.getId()));
            }
            if (synchronous) {
                while (this.updateTracker.contains(cruRev.getId())) {
                    try {
                        this.updateTracker.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public void checkRevisionDetailsIfQuick(CrucibleRevision cruRev, Source source) {
        if (source instanceof RepositorySource) {
            this.checkRevisionDetails(cruRev, source, false);
        }
    }

    private void checkRevisionDetails(CrucibleRevision cruRev, Source source, boolean synchronous) {
        if (!source.isAvailable()) {
            return;
        }
        if (this.needsUpdate(cruRev)) {
            if (source instanceof RepositorySource) {
                try {
                    FileRevisionInfo fri = source.getFileRevisionInfo(cruRev.getPath(), cruRev.getRevision());
                    this.updateDetails(cruRev, fri);
                }
                catch (FileRevisionException e2) {
                    Logs.APP_LOG.error((Object)("Couldn't update details on Crucible Revision " + cruRev), (Throwable)e2);
                }
            } else {
                this.updateRevision(cruRev, source, synchronous);
            }
        }
    }

    @Override
    public void checkRevisionDetailsSynchronously(CrucibleRevision cruRev, Source source) {
        this.checkRevisionDetails(cruRev, source, true);
    }

    private void updateDetails(final CrucibleRevision originalRevision, final FileRevisionInfo fri) {
        HibernateUtil.withRetriableTransaction(new HibernateUtil.WithSessionVisitor<Void>(){
            private final String stringRepresentation = DefaultContentManager.class.getSimpleName() + ".updateDetails";

            @Override
            public Void withSession(Session s2) {
                CrucibleRevision cruRev = (CrucibleRevision)s2.get(CrucibleRevision.class, (Serializable)originalRevision.getId());
                DefaultContentManager.updateCrucibleRevisionDetails(s2, cruRev, fri);
                return null;
            }

            public String toString() {
                return this.stringRepresentation;
            }
        });
        this.session().refresh((Object)originalRevision);
    }

    static void updateCrucibleRevisionDetails(Session s2, CrucibleRevision cruRev, FileRevisionInfo fri) {
        if (DefaultContentManager.doesRevisionNeedUpdate(cruRev)) {
            String deleted;
            String commitDateStr;
            Map<String, String> maybeDetails = fri.getDetails();
            cruRev.getDetails().putAll(maybeDetails);
            String authorName = maybeDetails.get("author");
            if (authorName != null) {
                cruRev.setAuthorName(authorName);
            }
            if ((commitDateStr = maybeDetails.get("commit_date")) != null) {
                Date commitDate = StringUtil.strToDate(commitDateStr);
                cruRev.setCommitDate(commitDate);
            }
            if ((deleted = maybeDetails.get("deleted")) != null) {
                cruRev.setDeletion("true".equals(deleted));
            }
            cruRev.setFileType(DefaultContentManager.getFileType(fri));
            cruRev.setDetailVersion(DETAIL_VERSION);
            s2.update((Object)cruRev);
        }
    }

    private boolean updateLinesAdded(CrucibleRevision cruRev, PatchSource source) {
        try {
            Pair<Integer, Integer> lineDetails = source.getLinesAddedRemoved(cruRev);
            if (lineDetails != null && lineDetails.getFirst() != null && lineDetails.getSecond() != null) {
                cruRev.getDetails().put("linesAdded", lineDetails.getFirst().toString());
                cruRev.getDetails().put("linesRemoved", lineDetails.getSecond().toString());
                return true;
            }
        }
        catch (FileRevisionException e2) {
            Logs.APP_LOG.warn((Object)"Problem getting lines added/removed", (Throwable)e2);
        }
        return false;
    }

    private void checkPatch(CrucibleRevision cruRev, Source source) {
        if (this.sourceFactory.isPatchSource(source)) {
            PatchSource ps = (PatchSource)source;
            Patch p2 = this.patchManager.findPatch(cruRev);
            if (p2 != null && p2.getUploadItem().getCharset() == null) {
                p2.getUploadItem().setCharset("UTF-8");
            }
            if (cruRev.getDetail("linesAdded") == null) {
                this.updateLinesAdded(cruRev, ps);
            }
        }
    }

    @Override
    public boolean needsUpdate(CrucibleRevision cruRev) {
        return DefaultContentManager.doesRevisionNeedUpdate(cruRev);
    }

    private static boolean doesRevisionNeedUpdate(CrucibleRevision cruRev) {
        return !DETAIL_VERSION.equals(cruRev.getDetailVersion()) || cruRev.isDeletion() == null || Strings.isNullOrEmpty((String)cruRev.getAuthorName());
    }

    @Override
    public Source getSource(String sourceName, Principal principal) {
        return this.sourceFactory.getSource(sourceName, principal);
    }

    @Override
    public CrucibleRevision getCrucibleRevision(Source source, RevInfoKey revInfoKey) {
        return this.getCrucibleRevision(source, revInfoKey.getPath().getPath(), revInfoKey.getRev());
    }

    @Override
    public CrucibleRevision getCrucibleRevision(final Source source, final String path, final String revision) {
        return this.txTemplate.execute(new TxCallback<CrucibleRevision>(){

            @Override
            public CrucibleRevision doInTransaction(TransactionStatus status) throws Exception {
                CrucibleRevision cruRev = FileRevisionManager.findRevision(source.getName(), path, revision);
                if (cruRev == null || DefaultContentManager.this.needsUpdate(cruRev)) {
                    FileRevisionInfo fri = null;
                    try {
                        fri = source.getFileRevisionInfo(path, revision);
                    }
                    catch (FileRevisionException e2) {
                        Logs.APP_LOG.error((Object)("couldn't get FileRevisionInfo for " + path + " " + revision), (Throwable)e2);
                    }
                    if (fri != null) {
                        cruRev = DefaultContentManager.this.makeCrucibleRevision(source.getName(), fri);
                    }
                }
                return cruRev;
            }
        });
    }

    public CrucibleRevision getLazyCrucibleRevision(Source source, RevInfoKey key) {
        return this.getLazyCrucibleRevision(source, key.getPath().getPath(), key.getRev());
    }

    @Override
    public CrucibleRevision getLazyCrucibleRevision(Source source, String path, String revision) {
        CrucibleRevision cruRev = FileRevisionManager.findRevision(source.getName(), path, revision);
        if (cruRev == null) {
            String displayRevision = source.getDisplayRevision(revision);
            cruRev = FileRevisionManager.createRevision(source.getName(), path, revision, displayRevision, new Date());
        }
        return cruRev;
    }

    @Override
    public Map<RevInfoKey, CrucibleRevision> getCrucibleRevisions(final Source source, Set<RevInfoKey> keys, boolean loadFileRevisionInfos) {
        Function<RevInfoKey, FileRevisionInfo> loadFileRevisionsInfoFromSource = new Function<RevInfoKey, FileRevisionInfo>(){

            public FileRevisionInfo apply(RevInfoKey revInfoKey) {
                try {
                    return source.getFileRevisionInfo(revInfoKey.getPath().getPath(), revInfoKey.getRev());
                }
                catch (FileRevisionException e2) {
                    Logs.APP_LOG.error((Object)("couldn't get FileRevisionInfo for " + revInfoKey), (Throwable)e2);
                    return null;
                }
            }
        };
        Option fileRevInfoLoader = loadFileRevisionInfos ? Option.some((Object)loadFileRevisionsInfoFromSource) : Option.none();
        return FileRevisionManager.createRevisions(source.getName(), keys, source, new Date(), (Option<Function<RevInfoKey, FileRevisionInfo>>)fileRevInfoLoader);
    }

    @Override
    public Map<RevInfoKey, CrucibleRevision> findCrucibleRevisions(Source source, Set<RevInfoKey> keys) {
        List<CrucibleRevision> revisions = CrucibleRevisionCreator.findRevisions(this.session(), source.getName(), keys);
        HashMap<RevInfoKey, CrucibleRevision> result = new HashMap<RevInfoKey, CrucibleRevision>();
        for (CrucibleRevision rev : revisions) {
            if (rev == null) continue;
            result.put(rev.getRevInfoKey(), rev);
        }
        return result;
    }

    @Override
    public CrucibleRevision getLazyCrucibleRevisionById(int cruRevId) {
        return FileRevisionManager.getById(cruRevId);
    }

    @Override
    public String getContentType(CrucibleRevision cruRev) {
        if (cruRev.isStored() && cruRev.getUploadItem().getOriginalContentType() != null) {
            return cruRev.getUploadItem().getOriginalContentType();
        }
        return this.guessContentType(cruRev);
    }

    @Override
    public InputStream getRawContents(CrucibleRevision cruRev, Principal principal, Disposer disposer) throws Exception {
        Source source = this.sourceFactory.getSource(cruRev.getSourceName(), principal);
        if (!source.isAuthorized()) {
            return null;
        }
        if (cruRev.isStored()) {
            return new FileInputStream(cruRev.getUploadItem().getItemFile());
        }
        if (source.isAvailable()) {
            File file = disposer.newDisposedTmpFile();
            source.copyFile(cruRev, file);
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    public CrucibleRevision makeCrucibleRevision(final String sourceName, final FileRevisionInfo fri) {
        return this.txTemplate.execute(new TxCallback<CrucibleRevision>(){

            @Override
            public CrucibleRevision doInTransaction(TransactionStatus status) throws Exception {
                return FileRevisionManager.createRevision(sourceName, fri, new Date());
            }
        });
    }

    @Override
    public List<CrucibleRevision> makeCrucibleRevisions(final Source source, final List<FileRevisionInfo> fris) {
        return this.txTemplate.execute(new TxCallback<List<CrucibleRevision>>(){

            @Override
            public List<CrucibleRevision> doInTransaction(TransactionStatus status) throws Exception {
                ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>(fris.size());
                Map<FileRevisionInfo, CrucibleRevision> revisionsMap = FileRevisionManager.createRevisionsFromFRIs(source, fris, new Date());
                revisions.addAll(revisionsMap.values());
                return revisions;
            }
        });
    }

    @Override
    public CrucibleRevision makeMinimalCrucibleRevision(final String sourceName, final String path, final String revision, final boolean deleted, final Map<String, String> maybeDetails) {
        return this.txTemplate.execute(new TxCallback<CrucibleRevision>(){

            @Override
            public CrucibleRevision doInTransaction(TransactionStatus status) throws Exception {
                CrucibleRevision cruRev = FileRevisionManager.findRevision(sourceName, path, revision);
                if ((cruRev == null || cruRev.isDeletion() == null || DefaultContentManager.this.detailsUpdated(cruRev, maybeDetails)) && cruRev == null) {
                    cruRev = FileRevisionManager.createRevision(sourceName, path, revision, revision, new Date(), deleted, maybeDetails);
                }
                return cruRev;
            }
        });
    }

    private boolean detailsUpdated(CrucibleRevision cruRev, Map<String, String> maybeDetails) {
        Boolean deleted1;
        if (maybeDetails == null || maybeDetails.isEmpty()) {
            return false;
        }
        Boolean deleted0 = cruRev.isDeletion();
        String deleteStr1 = maybeDetails.get("deleted");
        Boolean bl = deleted1 = deleteStr1 == null ? null : Boolean.valueOf(deleteStr1.equals("true"));
        if (!Objects.equal((Object)deleted0, (Object)deleted1)) {
            return true;
        }
        Map<String, String> details = cruRev.getDetails();
        if (!details.keySet().containsAll(maybeDetails.keySet())) {
            return true;
        }
        for (Map.Entry<String, String> entry : maybeDetails.entrySet()) {
            if (StringUtil.equalsWithNullsAsEmpty(entry.getValue(), details.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    private static String getFileType(FileRevisionInfo fri) {
        String s2 = fri.getDetails().get("filetype");
        boolean isDir = "dir".equals(s2);
        return isDir ? ContentManager.FileType.DIRECTORY.toString() : ContentManager.FileType.FILE.toString();
    }

    public static Integer getIntegerDetail(CrucibleRevision cruRev, String key) {
        String detail = cruRev.getDetail(key);
        if (Strings.isNullOrEmpty((String)detail)) {
            return null;
        }
        try {
            return Integer.parseInt(detail);
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.error((Object)(key + "is not an Integer detail"), (Throwable)e2);
            return null;
        }
    }

    private static boolean isDirectory(CrucibleRevision cruRev) {
        return ContentManager.FileType.DIRECTORY.name().equals(cruRev.getFileType());
    }

    @Autowired
    public void setSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
    }

    @Override
    public IndexedLineReader getContents(Source source, Project project, final CrucibleRevision cruRev, Disposer disposer, String keywordOpts) throws Exception {
        Logs.APP_LOG.debug((Object)("getting contents of " + cruRev));
        this.checkAndStoreContents(project, cruRev, source);
        if (Boolean.TRUE.equals(cruRev.isDeletion())) {
            return new StringIndexedLineReader(Collections.emptyList());
        }
        if (cruRev.isBinaryOrOversize()) {
            return null;
        }
        if (cruRev.isStored()) {
            try {
                return this.encodedContentProvider.getContent(cruRev.getUploadItem(), disposer);
            }
            catch (FileNotFoundException e2) {
                if (source instanceof RepositorySource || source instanceof SCMSource) {
                    Logs.APP_LOG.info((Object)("Cached Review Content is missing: " + e2.getMessage() + ". Will attempt retrieval from SCM: " + source.getName()));
                    try {
                        this.txTemplate.execute(new TxCallback<Void>(){

                            @Override
                            public Void doInTransaction(TransactionStatus status) throws Exception {
                                UploadItem uploadItem = cruRev.getUploadItem();
                                cruRev.setUploadItem(null);
                                DefaultContentManager.this.session().delete((Object)uploadItem);
                                return null;
                            }
                        });
                    }
                    catch (DbException dbException) {}
                }
                Logs.APP_LOG.error((Object)("The file containing uploaded content for path '" + cruRev.getPath() + "' from source '" + source.getName() + "' is missing: " + e2.getMessage() + "."));
            }
        }
        if (source.isAvailable()) {
            if (keywordOpts != null) {
                Logs.APP_LOG.warn((Object)("keywordOpts is not expected to be used, and causes lower performance. Value is: '" + keywordOpts + "'"));
                return source.getFileContents(cruRev, keywordOpts, disposer);
            }
            return source.getCachedEncodedFileContents(cruRev, disposer);
        }
        return null;
    }

    @Override
    public FileRevisionInfo loopBackFRI(CrucibleRevision cruRev) {
        return new FileRevisionInfo(cruRev.getDetail("branch"), this.getDiffRevKeyFromCache(cruRev), cruRev.getRevision(), cruRev.getRevisionDisplayName(), cruRev.getAuthorName(), cruRev.getPath(), cruRev.getCommitDate(), cruRev.getDetail("comment"), DefaultContentManager.isTrue(cruRev.isDeletion()), DefaultContentManager.isTrue(cruRev.isBinary()), DefaultContentManager.isDirectory(cruRev), cruRev.isDetailSetTrue("annotatable"), DefaultContentManager.isTrue(cruRev.isAdded()), DefaultContentManager.isTrue(cruRev.isModified()), DefaultContentManager.isTrue(cruRev.isMoved()), DefaultContentManager.isTrue(cruRev.isCopied()), DefaultContentManager.getIntegerDetail(cruRev, "linesAdded"), DefaultContentManager.getIntegerDetail(cruRev, "linesRemoved"), DefaultContentManager.isTrue(cruRev.isOversize()));
    }

    private static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    @Override
    public RevInfoKey getDiffRevKeyFromCache(CrucibleRevision cruRev) {
        String rev = cruRev.getDetail("diffRevision");
        String path = cruRev.getDetail("diffPath");
        return rev == null || path == null ? null : new RevInfoKey(new Path(path), rev);
    }

    private class Updater
    implements Runnable {
        Source source;
        Integer cruRevId;

        private Updater(Source source, Integer cruRevId) {
            this.source = source;
            this.cruRevId = cruRevId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session session = DefaultContentManager.this.currentSessionProvider.currentSession();
            try {
                DefaultContentManager.this.txTemplate.execute(new TxCallback<Void>(){

                    @Override
                    public Void doInTransaction(TransactionStatus status) throws Exception {
                        CrucibleRevision cruRev = FileRevisionManager.getById(Updater.this.cruRevId);
                        DefaultContentManager.this.checkPatch(cruRev, Updater.this.source);
                        FileRevisionInfo fri = Updater.this.source.getFileRevisionInfo(cruRev.getPath(), cruRev.getRevision());
                        DefaultContentManager.this.updateDetails(cruRev, fri);
                        Logs.APP_LOG.debug((Object)("Saved details for " + cruRev));
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"Couldn't update details on Crucible Revision", (Throwable)e2);
            }
            finally {
                session.close();
                Set set = DefaultContentManager.this.updateTracker;
                synchronized (set) {
                    DefaultContentManager.this.updateTracker.remove(this.cruRevId);
                    DefaultContentManager.this.updateTracker.notifyAll();
                }
            }
        }
    }
}

