/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.managers;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.DefaultContentManager;
import com.cenqua.crucible.revision.source.DisplayRevisionMapper;
import com.cenqua.crucible.util.CriteriaBatchedInClauseHelper;
import com.cenqua.crucible.util.HqlBatchedInClauseHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.CollectionsUtil;
import com.cenqua.fisheye.util.HashUtils;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.Session;

public class CrucibleRevisionCreator {
    public static final String CRU_REVISION_QUERY_CACHE_REGION_NAME = "com.cenqua.crucible.model.CrucibleRevision.QUERY";
    public static final int SESSION_FLUSH_INTERVAL = 20;
    public static final Logger log = Logs.loggerFor(CrucibleRevisionCreator.class);

    public static StoredPath findStoredPath(Session session, String path) {
        return (StoredPath)session.createQuery("from StoredPath storedPath where storedPath.hash = :pathHash").setString("pathHash", HashUtils.getDefaultDigestHexEncoded(path)).uniqueResult();
    }

    @VisibleForTesting
    static Map<String, StoredPath> findStoredPaths(Session session, List<String> paths) {
        Query pathQuery = session.createQuery("from StoredPath storedPath where storedPath.hash in (:pathHashes)");
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(pathQuery, "pathHashes", Lists.transform(paths, StoredPath.PATH_HASHING_FUNCTION));
        final HashMap result = Maps.newHashMap();
        helper.execute(new StoppableVisitor<StoredPath>(){

            @Override
            public boolean visit(StoredPath storedPath) {
                result.put(storedPath.getPath(), storedPath);
                return true;
            }
        }, false);
        return result;
    }

    @VisibleForTesting
    static StoredPath createPathIfNotFound(Session session, String path) {
        StoredPath storedPath = CrucibleRevisionCreator.findStoredPath(session, path);
        if (storedPath == null) {
            storedPath = CrucibleRevisionCreator.createPath(session, path);
        } else if (!storedPath.getPath().equals(path)) {
            CrucibleRevisionCreator.throwStoredPathInconsitencyException(storedPath, path);
        }
        return storedPath;
    }

    @VisibleForTesting
    public static StoredPath createPath(Session session, String path) {
        StoredPath storedPath = new StoredPath(path, HashUtils.getDefaultDigestHexEncoded(path));
        session.save((Object)storedPath);
        return storedPath;
    }

    private static void throwStoredPathInconsitencyException(StoredPath storedPath, String path) {
        Logs.APP_LOG.fatal((Object)("Hash (SHA-256) conflict found: StoredPath(" + storedPath.getId() + "," + storedPath.getPath() + ") is found to have same hash [" + storedPath.getHash() + "] as path [" + path + "]"));
        throw new RuntimeException("System error occurred, unable to complete requested operation. Please consult system logs for more details.");
    }

    public static CrucibleRevision findRevision(Session session, String source, String path, String rev) {
        StoredPath sp = CrucibleRevisionCreator.findStoredPath(session, path);
        if (sp == null) {
            return null;
        }
        return CrucibleRevisionCreator.findRevision(session, source, sp, rev);
    }

    static List<CrucibleRevision> findRevisions(Session session, String source, final Set<RevInfoKey> revInfoKeys) {
        Query revQuery = session.createQuery("from CrucibleRevision crucibleRevision join crucibleRevision.storedPath path where crucibleRevision.sourceName = :source and path.hash in (:pathHashes)");
        revQuery.setString("source", source);
        HashSet<String> pathHashes = new HashSet<String>();
        for (RevInfoKey revInfoKey : revInfoKeys) {
            pathHashes.add(HashUtils.getDefaultDigestHexEncoded(revInfoKey.getPath().getPath()));
        }
        final ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>();
        HqlBatchedInClauseHelper helper = new HqlBatchedInClauseHelper(revQuery, "pathHashes", CollectionsUtil.asList(pathHashes));
        helper.execute(new StoppableVisitor<Object[]>(){

            @Override
            public boolean visit(Object[] revPathPair) {
                CrucibleRevision rev = (CrucibleRevision)revPathPair[0];
                if (revInfoKeys.contains(rev.getRevInfoKey())) {
                    revisions.add(rev);
                    if (revisions.size() == revInfoKeys.size()) {
                        return false;
                    }
                }
                return true;
            }
        }, true);
        return revisions;
    }

    private static CrucibleRevision findRevision(Session session, String source, StoredPath sp, String rev) {
        return (CrucibleRevision)session.createQuery("from CrucibleRevision fileRevision where fileRevision.sourceName = :source and fileRevision.storedPath = :path and fileRevision.revision = :rev ").setString("source", source).setEntity("path", (Object)sp).setString("rev", rev).setCacheable(true).setCacheRegion(CRU_REVISION_QUERY_CACHE_REGION_NAME).uniqueResult();
    }

    @VisibleForTesting
    protected static PartialResult findPersistedRevisions(Session session, String source, Set<RevInfoKey> keys) {
        HashMap<RevInfoKey, CrucibleRevision> results = new HashMap<RevInfoKey, CrucibleRevision>();
        HashSet<RevInfoKey> missing = new HashSet<RevInfoKey>(keys);
        List<CrucibleRevision> crucibleRevisions = CrucibleRevisionCreator.findRevisions(session, source, keys);
        for (CrucibleRevision cruRev : crucibleRevisions) {
            RevInfoKey rik = cruRev.getRevInfoKey();
            results.put(rik, cruRev);
            missing.remove(rik);
        }
        return new PartialResult(results, missing);
    }

    public static CrucibleRevision createRevision(Session originalSession, String source, FileRevisionInfo fri, String path, String revision, String revisionDisplayName, Date createDate, Boolean deleted, Map<String, String> maybeDetails) {
        CrucibleRevision r2 = CrucibleRevisionCreator.findRevision(originalSession, source, path, revision);
        if (r2 != null) {
            return r2;
        }
        Integer id = CrucibleRevisionCreator.createRevisionInSeparateTransaction(source, fri, path, revision, revisionDisplayName, createDate, deleted, maybeDetails);
        r2 = (CrucibleRevision)originalSession.get(CrucibleRevision.class, (Serializable)id);
        if (r2 == null) {
            throw new IllegalStateException("Could not retrieve revision created on other transaction");
        }
        return r2;
    }

    public static Map<RevInfoKey, CrucibleRevision> createRevisions(Session originalSession, String source, Set<RevInfoKey> revKeys, DisplayRevisionMapper mapper, Date createDate, Option<Function<RevInfoKey, FileRevisionInfo>> fileRevInfoLoader) {
        final HashMap<RevInfoKey, CrucibleRevision> results = new HashMap<RevInfoKey, CrucibleRevision>(revKeys.size());
        PartialResult info = CrucibleRevisionCreator.findPersistedRevisions(originalSession, source, revKeys);
        if (info.missing.isEmpty()) {
            return info.results;
        }
        List<Integer> ids = CrucibleRevisionCreator.createRevisionsInSeparateTransaction(source, revKeys, mapper, createDate, fileRevInfoLoader);
        CriteriaBatchedInClauseHelper<Integer> batcher = new CriteriaBatchedInClauseHelper<Integer>(originalSession, CrucibleRevision.class, criteria -> criteria.setFetchMode("spr.storedPath", FetchMode.JOIN), "id", ids);
        batcher.execute(new StoppableVisitor<CrucibleRevision>(){

            @Override
            public boolean visit(CrucibleRevision revision) {
                results.put(revision.getRevInfoKey(), revision);
                return true;
            }
        });
        if (ids.size() > results.size()) {
            throw new IllegalStateException("Only " + results.size() + " of requested " + ids.size() + " revisions successfully load.");
        }
        return results;
    }

    @VisibleForTesting
    static List<Integer> createRevisionsInSeparateTransaction(final String source, final Set<RevInfoKey> revKeys, final DisplayRevisionMapper mapper, final Date createDate, final Option<Function<RevInfoKey, FileRevisionInfo>> fileRevInfoLoader) {
        return HibernateUtil.withRetriableTransaction(new HibernateUtil.WithSessionVisitor<List<Integer>>(){
            private final String stringRepresentation = CrucibleRevisionCreator.class.getSimpleName() + ".createRevisionsInSeparateTransaction";

            @Override
            public List<Integer> withSession(final Session s2) {
                log.debug((Object)String.format("CreateRevisions for %s revisions for %s", revKeys.size(), source));
                PartialResult info = CrucibleRevisionCreator.findPersistedRevisions(s2, source, revKeys);
                ArrayList<Integer> newids = new ArrayList<Integer>();
                newids.addAll(Collections2.transform(info.results.values(), (Function)new Function<CrucibleRevision, Integer>(){

                    public Integer apply(CrucibleRevision input) {
                        return input.getId();
                    }
                }));
                if (!info.missing.isEmpty()) {
                    log.debug((Object)String.format("Creating %s missing revisions", info.missing.size()));
                    ArrayList missingRevKeysSorted = Lists.newArrayList(info.missing);
                    Collections.sort(missingRevKeysSorted, new Comparator<RevInfoKey>(){

                        @Override
                        public int compare(RevInfoKey o1, RevInfoKey o2) {
                            boolean pathComparisonResult = o1.getPath().equals(o2.getPath());
                            return pathComparisonResult ? o1.getRev().compareTo(o2.getRev()) : o1.getPath().compareTo(o2.getPath());
                        }
                    });
                    Map<String, StoredPath> storedPaths = CrucibleRevisionCreator.findStoredPaths(s2, Lists.transform((List)missingRevKeysSorted, (Function)new Function<RevInfoKey, String>(){

                        public String apply(RevInfoKey revInfoKey) {
                            return revInfoKey.getPathAsString();
                        }
                    }));
                    log.debug((Object)String.format("Found %s existing stored paths for %s revisions", storedPaths.size(), missingRevKeysSorted.size()));
                    int i2 = 0;
                    for (final RevInfoKey key : missingRevKeysSorted) {
                        String path = key.getPath().getPath();
                        StoredPath sp = storedPaths.get(path);
                        if (sp == null) {
                            sp = CrucibleRevisionCreator.createPath(s2, path);
                            storedPaths.put(path, sp);
                        }
                        final CrucibleRevision cruRev = new CrucibleRevision(source, sp, key.getRev(), mapper.getDisplayRevision(key.getRev()), createDate);
                        s2.save((Object)cruRev);
                        newids.add(cruRev.getId());
                        fileRevInfoLoader.foreach((Effect)new Effect<Function<RevInfoKey, FileRevisionInfo>>(){

                            public void apply(Function<RevInfoKey, FileRevisionInfo> fileRevInfoLoader) {
                                FileRevisionInfo fri = (FileRevisionInfo)fileRevInfoLoader.apply((Object)key);
                                if (fri != null) {
                                    DefaultContentManager.updateCrucibleRevisionDetails(s2, cruRev, fri);
                                }
                            }
                        });
                        if (++i2 % 20 != 0) continue;
                        s2.flush();
                    }
                    CrucibleRevisionCreator.evictQueries();
                }
                return newids;
            }

            public String toString() {
                return this.stringRepresentation;
            }
        });
    }

    private static Integer createRevisionInSeparateTransaction(final String source, final FileRevisionInfo fri, final String path, final String revision, final String revisionDisplayName, final Date createDate, final Boolean deleted, final Map<String, String> maybeDetails) {
        return HibernateUtil.withRetriableTransaction(new HibernateUtil.WithSessionVisitor<Integer>(){
            private final String stringRepresentation = CrucibleRevisionCreator.class.getSimpleName() + ".createRevisionInSeparateTransaction";

            @Override
            public Integer withSession(Session s2) {
                StoredPath sp = CrucibleRevisionCreator.createPathIfNotFound(s2, path);
                CrucibleRevision r2 = CrucibleRevisionCreator.findRevision(s2, source, sp, revision);
                if (r2 == null) {
                    r2 = new CrucibleRevision(source, sp, revision, revisionDisplayName, createDate);
                    s2.save((Object)r2);
                    CrucibleRevisionCreator.evictQueries();
                }
                if (fri != null) {
                    DefaultContentManager.updateCrucibleRevisionDetails(s2, r2, fri);
                }
                if (deleted != null) {
                    r2.setDeletion(deleted);
                }
                if (maybeDetails != null) {
                    r2.getDetails().putAll(maybeDetails);
                    String authorName = (String)maybeDetails.get("author");
                    if (authorName != null) {
                        r2.setAuthorName(authorName);
                    }
                    String commitDateStr = (String)maybeDetails.get("commit_date");
                    Date commitDate = StringUtil.strToDate(commitDateStr);
                    r2.setCommitDate(commitDate);
                }
                return r2.getId();
            }

            public String toString() {
                return this.stringRepresentation;
            }
        });
    }

    private static void evictQueries() {
        HibernateUtil.getSessionFactory().getCache().evictQueryRegion(CRU_REVISION_QUERY_CACHE_REGION_NAME);
    }

    private static class PartialResult {
        final Map<RevInfoKey, CrucibleRevision> results;
        final Set<RevInfoKey> missing;

        PartialResult(Map<RevInfoKey, CrucibleRevision> results, Set<RevInfoKey> missing) {
            this.results = results;
            this.missing = missing;
        }
    }
}

