/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.atlassian.fugue.Either;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.unified.DiffHeader;
import com.cenqua.crucible.revision.diff.unified.DiffHeaderParser;
import com.cenqua.crucible.revision.diff.unified.DiffHeaderParserSectionResult;
import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.crucible.revision.diff.unified.SectionHeader;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffListener;
import com.cenqua.fisheye.io.ReaderLineReader;
import java.io.IOException;

public class UnifiedDiffParser {
    private ReaderLineReader reader;
    private UnifiedDiffListener listener;

    private DiffHeader parseHeaders(int index) throws IOException {
        String line;
        int current = 0;
        block0: while ((line = this.reader.readLine()) != null) {
            for (DiffHeaderParser parser : DiffHeaderParser.values()) {
                DiffHeader diffHeader;
                if (!parser.matches(line) || (diffHeader = parser.parseHeaders(line, this.reader)) == null) continue;
                if (current == index) {
                    this.listener.fromHeader(diffHeader.getFromHeader());
                    this.listener.toHeader(diffHeader.getToHeader());
                    return diffHeader;
                }
                ++current;
                continue block0;
            }
        }
        return null;
    }

    public void processRevision(ReaderLineReader reader, UnifiedDiffListener listener, int revisionIndex) throws IOException, PatchException {
        this.reader = reader;
        this.listener = listener;
        this.processRevision(revisionIndex);
    }

    private boolean processRevision(int index) throws IOException, PatchException {
        DiffHeader diffHeader = this.parseHeaders(index);
        String line = this.reader.readLine();
        if (diffHeader != null) {
            DiffHeaderParser parser = diffHeader.getParser();
            Either<DiffHeaderParserSectionResult, SectionHeader> section = parser.getSection(line, this.reader);
            if (section.isRight()) {
                while ((line = this.processSection((SectionHeader)section.right().get())) != null && (section = parser.getSection(line, this.reader)).isRight()) {
                }
            } else {
                switch ((DiffHeaderParserSectionResult)((Object)section.left().get())) {
                    case NO_SECTION: {
                        throw new PatchException("Unrecognised diff format. Expected diff hunk descriptor but found: " + line);
                    }
                }
            }
        }
        if (diffHeader == null || line == null) {
            this.listener.eof();
            return false;
        }
        return true;
    }

    public void processAllRevisions(ReaderLineReader reader, UnifiedDiffListener listener) throws IOException, PatchException {
        boolean moreLinesToRead;
        this.reader = reader;
        this.listener = listener;
        while (moreLinesToRead = this.processRevision(0)) {
        }
    }

    private String processSection(SectionHeader section) throws IOException {
        String line;
        int fromLine = section.getFromLine();
        int numFromLines = section.getNumberFromLines() == null ? 0 : section.getNumberFromLines();
        int toLine = section.getToLine();
        int numToLines = section.getNumberToLines() == null ? 0 : section.getNumberToLines();
        this.listener.section(fromLine, numFromLines, toLine, numToLines);
        block6: while ((line = this.reader.readLine()) != null) {
            String nextLine;
            RevisionHeader from = DiffMatcher.matchHeader(true, line);
            if (from != null && (nextLine = this.reader.readLine()) != null) {
                this.reader.pushLineBack(nextLine);
                RevisionHeader to = DiffMatcher.matchHeader(false, nextLine);
                if (to != null) {
                    return line;
                }
            }
            switch (line.charAt(0)) {
                case '+': {
                    this.listener.addLine(line.substring(1));
                    continue block6;
                }
                case '-': {
                    this.listener.removeLine(line.substring(1));
                    continue block6;
                }
                case ' ': {
                    this.listener.contextLine(line.substring(1));
                    continue block6;
                }
                case '\\': {
                    continue block6;
                }
            }
            return line;
        }
        return null;
    }
}

