/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class RevisionHeader {
    private final String path;
    private final boolean nullRev;
    private String revision;
    private HashMatchType matchType;

    RevisionHeader(Matcher m2) {
        this.path = StringUtils.chomp((String)m2.group(1));
        Matcher mn = DiffMatcher.NULL_REVISION.matcher(this.getPath());
        boolean bl = this.nullRev = mn.find() || "0".equals(m2.group(3));
        this.revision = this.isNullRev() ? null : (Strings.isNullOrEmpty((String)m2.group(3)) ? "(no revision)" : StringUtils.chomp((String)m2.group(3)));
    }

    RevisionHeader(String path, String revision, boolean nullRev) {
        this.path = path;
        this.revision = revision;
        this.nullRev = nullRev;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean isNullRev() {
        return this.nullRev;
    }

    public HashMatchType getHashMatchType() {
        return this.matchType;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setHashMatchType(HashMatchType matchType) {
        this.matchType = matchType;
    }
}

