/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.atlassian.fisheye.git.client.GitDiffParser;
import com.cenqua.crucible.revision.diff.unified.GitDiffListener;
import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.util.Pair;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;

public class GitDiffHeaderParser
implements GitDiffListener {
    private static final String NULL_REV = "/dev/null";
    private String fromRev;
    private String toRev;
    private String fromPath;
    private String toPath;
    private boolean isFromRevNull;
    private boolean isToRevNull;
    private final GitDiffParser parser;

    public GitDiffHeaderParser(boolean isPrefixed) {
        this.parser = isPrefixed ? new GitDiffParser(this, "a/", "b/", true) : new GitDiffParser(this, "", "", true);
    }

    @Override
    public void removeLine(String line) {
    }

    @Override
    public void addLine(String line) {
    }

    @Override
    public void revisionInfo(String fromRev, String toRev, String mode) {
        this.fromRev = fromRev;
        this.toRev = toRev;
    }

    @Override
    public void fileChangeInfo(String operator, String mode) {
    }

    @Override
    public void binaryHeader() {
    }

    @Override
    public void similarityIndex(String operator, double similarityValue) {
    }

    @Override
    public void renameFrom(String path) {
        this.fromPath = path;
    }

    @Override
    public void copyFrom(String path) {
        this.fromPath = path;
    }

    @Override
    public void renameTo(String path) {
        this.toPath = path;
    }

    @Override
    public void copyTo(String path) {
        this.toPath = path;
    }

    @Override
    public void diffHeader(String fromPath, String toPath) {
        this.fromPath = fromPath;
        this.toPath = toPath;
    }

    @Override
    public void section(String sectionHeader) {
    }

    @Override
    public void fromHeader(String path) {
        if (path.equals(NULL_REV)) {
            this.fromPath = path;
            this.isFromRevNull = true;
        }
    }

    @Override
    public void toHeader(String path) {
        if (path.equals(NULL_REV)) {
            this.toPath = path;
            this.isToRevNull = true;
        }
    }

    private boolean isHeaderComplete() {
        return this.fromPath != null && this.toPath != null && this.fromRev != null && this.toRev != null;
    }

    public Pair<RevisionHeader, RevisionHeader> parseHeaders(String line, ReaderLineReader lineReader) throws IOException {
        LinkedList<String> lineBuffer = new LinkedList<String>();
        do {
            GitDiffParser.ParserState state;
            if ((state = this.parser.processLine(StringUtils.chomp((String)line))) == GitDiffParser.ParserState.DIFF_STARTED && this.fromRev == null) {
                while (!lineBuffer.isEmpty()) {
                    lineReader.pushLineBack((String)lineBuffer.removeLast());
                }
                return null;
            }
            if (state == GitDiffParser.ParserState.IN_SECTION) break;
            line = lineReader.readLine();
            lineBuffer.add(line);
        } while (line != null);
        lineReader.pushLineBack(line);
        if (!this.isHeaderComplete()) {
            return null;
        }
        RevisionHeader from = new RevisionHeader(this.fromPath, this.fromRev, this.isFromRevNull);
        RevisionHeader to = new RevisionHeader(this.toPath, this.toRev, this.isToRevNull);
        from.setHashMatchType(HashMatchType.CONTENT);
        to.setHashMatchType(HashMatchType.CONTENT);
        return Pair.newInstance(from, to);
    }
}

