/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.crucible.revision.diff.unified.SectionHeader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DiffMatcher {
    public static final String DEFAULT_GIT_FROM_PREFIX = "a/";
    public static final String DEFAULT_GIT_TO_PREFIX = "b/";
    protected static final Pattern GIT_PREFIXED_HEADER = Pattern.compile("^diff --git \"?a/(.*) \"?b/(.*)$");
    protected static final Pattern HG_COMMIT_HASH_HEADER = Pattern.compile("^diff\\s-r\\s([a-f0-9]+)(?:\\s-r\\s([a-f0-9]+))?\\s(?:.*)");
    protected static final Pattern CVS_REV_HEADER = Pattern.compile("^retrieving revision (.*)");
    protected static final Pattern P4_HEADER = Pattern.compile("^==== ([^#]+)#([\\d]+).*");
    protected static final Pattern P4_NEW_HEADER_DEPOT_FILE = Pattern.compile("^\\.\\.\\. depotFile (.*)");
    protected static final Pattern P4_NEW_HEADER_CLIENT_FILE = Pattern.compile("^\\.\\.\\. clientFile (.*)");
    protected static final Pattern P4_NEW_HEADER_REV = Pattern.compile("^\\.\\.\\. rev (.*)");
    protected static final Pattern P4_NEW_HEADER_TYPE = Pattern.compile("^\\.\\.\\. type (.*)");
    public static final String NO_REVISION = "(no revision)";
    private static final String HEADER_PATH_MATCH = "[ \\t]([^\\t]+)";
    private static final String HEADER_REV_MATCH = "(?:(?:\\s+\\(\\.\\.\\.[^)]*\\))?\\s+\\(?(revision\\s)?([^\\n^\\)]*)?\\)?)?";
    public static final Pattern FROM_HEADER = Pattern.compile("^[-]{3}[ \\t]([^\\t]+)(?:(?:\\s+\\(\\.\\.\\.[^)]*\\))?\\s+\\(?(revision\\s)?([^\\n^\\)]*)?\\)?)?");
    public static final Pattern TO_HEADER = Pattern.compile("^[+]{3}[ \\t]([^\\t]+)(?:(?:\\s+\\(\\.\\.\\.[^)]*\\))?\\s+\\(?(revision\\s)?([^\\n^\\)]*)?\\)?)?");
    protected static final Pattern NULL_REVISION = Pattern.compile("dev/null");
    protected static final Pattern SECTION_DESCRIPTION = Pattern.compile("@@\\s-(\\d+),?(\\d+)?\\s\\+(\\d+),?(\\d+)?\\s@@");

    private DiffMatcher() {
    }

    protected static Matcher findMatch(Pattern pat, String string) {
        Matcher m2 = pat.matcher(string);
        if (m2.find()) {
            return m2;
        }
        return null;
    }

    protected static RevisionHeader matchHeader(boolean from, String line) {
        Matcher m2 = DiffMatcher.findMatch(from ? FROM_HEADER : TO_HEADER, line);
        if (m2 == null) {
            return null;
        }
        RevisionHeader header = new RevisionHeader(m2);
        header.setHashMatchType(HashMatchType.COMMIT);
        return header;
    }

    protected static SectionHeader matchSection(String line) {
        Matcher m2 = DiffMatcher.findMatch(SECTION_DESCRIPTION, line);
        if (m2 == null) {
            return null;
        }
        return new SectionHeader(m2);
    }
}

