/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.atlassian.fisheye.git.client.GitDiffParser;
import com.atlassian.fugue.Either;
import com.cenqua.crucible.revision.diff.unified.DiffHeader;
import com.cenqua.crucible.revision.diff.unified.DiffHeaderParserSectionResult;
import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.crucible.revision.diff.unified.GitDiffHeaderParser;
import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.crucible.revision.diff.unified.SectionHeader;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public enum DiffHeaderParser {
    GIT_WITH_PREFIX(DiffMatcher.GIT_PREFIXED_HEADER, HashMatchType.CONTENT){

        @Override
        public DiffHeader parseHeaders(String line, ReaderLineReader lineReader) throws IOException {
            GitDiffHeaderParser parser = new GitDiffHeaderParser(true);
            Pair<RevisionHeader, RevisionHeader> headers = parser.parseHeaders(line, lineReader);
            if (headers == null) {
                return null;
            }
            return new DiffHeader(headers.getFirst(), headers.getSecond(), this);
        }
    }
    ,
    GIT_WITHOUT_PREFIX(GitDiffParser.DIFF_PATTERN, HashMatchType.CONTENT){

        @Override
        public DiffHeader parseHeaders(String line, ReaderLineReader lineReader) throws IOException {
            GitDiffHeaderParser parser = new GitDiffHeaderParser(false);
            Pair<RevisionHeader, RevisionHeader> headers = parser.parseHeaders(line, lineReader);
            if (headers == null) {
                return null;
            }
            return new DiffHeader(headers.getFirst(), headers.getSecond(), this);
        }
    }
    ,
    HG(DiffMatcher.HG_COMMIT_HASH_HEADER, HashMatchType.COMMIT){

        @Override
        String getFromRev(Matcher matcher) {
            return matcher.group(1);
        }

        @Override
        String getToRev(Matcher matcher) {
            return matcher.group(2);
        }
    }
    ,
    CVS(DiffMatcher.CVS_REV_HEADER){

        @Override
        String getFromRev(Matcher matcher) {
            return matcher.group(1);
        }
    }
    ,
    P4(DiffMatcher.P4_HEADER, true){

        @Override
        String getFromRev(Matcher matcher) {
            return matcher.group(2);
        }

        @Override
        String getToRev(Matcher matcher) {
            return "working copy";
        }

        @Override
        String getFromPath(Matcher matcher) {
            return matcher.group(1);
        }

        @Override
        String getToPath(Matcher matcher) {
            return this.getFromPath(matcher);
        }

        @Override
        @Nonnull
        Either<DiffHeaderParserSectionResult, SectionHeader> getSection(String line, ReaderLineReader lineReader) throws IOException {
            if (this.matches(line)) {
                Logs.APP_LOG.debug((Object)"Skipping empty p4 diff");
                lineReader.pushLineBack(line);
                return Either.left((Object)((Object)DiffHeaderParserSectionResult.SKIPPABLE_SECTION));
            }
            return super.getSection(line, lineReader);
        }
    }
    ,
    P4NEW(DiffMatcher.P4_NEW_HEADER_DEPOT_FILE){
        private final Set<String> BINARY_FILETYPES = ImmutableSet.of((Object)"binary", (Object)"xbinary", (Object)"ubinary", (Object)"uxbinary", (Object)"tempobj", (Object)"ctempobj", (Object[])new String[]{"xtempobj", "symlink"});
        private static final String BINARY_CONTENT_DIFF = "(... files differ ...)";

        @Override
        public DiffHeader parseHeaders(String line, ReaderLineReader lineReader) throws IOException {
            Optional<Matcher> type;
            Optional<Matcher> rev;
            Optional<Matcher> clientFile;
            Optional<Matcher> depotFile;
            block1: {
                block2: {
                    String filesDifferLine;
                    lineReader.pushLineBack(line);
                    do {
                        depotFile = this.match(DiffMatcher.P4_NEW_HEADER_DEPOT_FILE, lineReader);
                        clientFile = this.match(DiffMatcher.P4_NEW_HEADER_CLIENT_FILE, lineReader);
                        rev = this.match(DiffMatcher.P4_NEW_HEADER_REV, lineReader);
                        type = this.match(DiffMatcher.P4_NEW_HEADER_TYPE, lineReader);
                        if (!Stream.of(depotFile, clientFile, rev, type).allMatch(Optional::isPresent)) break block1;
                        lineReader.readLine();
                        if (!this.BINARY_FILETYPES.contains(type.get().group(1))) break block2;
                        Logs.APP_LOG.debug((Object)("Skipping binary file " + depotFile.get().group(1)));
                        filesDifferLine = lineReader.readLine();
                    } while (BINARY_CONTENT_DIFF.equals(filesDifferLine));
                    Logs.APP_LOG.warn((Object)("Unexpected Perforce diff binary file diff line: " + filesDifferLine));
                    lineReader.pushLineBack(filesDifferLine);
                    return null;
                }
                return new DiffHeader(new RevisionHeader(depotFile.get().group(1), rev.get().group(1), false), new RevisionHeader(depotFile.get().group(1), "working copy", false), this);
            }
            Logs.APP_LOG.warn((Object)("Incomplete match for Perforce diff header. Found: " + Stream.of(depotFile, clientFile, rev, type).filter(Optional::isPresent).map(matcher -> ((Matcher)matcher.get()).group()).collect(Collectors.joining(", "))));
            Stream.of(type, rev, clientFile, depotFile).filter(Optional::isPresent).forEachOrdered(header -> lineReader.pushLineBack(((Matcher)header.get()).group()));
            return null;
        }

        private Optional<Matcher> match(Pattern pattern, ReaderLineReader lineReader) throws IOException {
            Optional<Matcher> result;
            String line = lineReader.readLine();
            if (line == null) {
                result = Optional.empty();
            } else {
                Matcher matcher = pattern.matcher(line);
                Optional<Object> optional = result = matcher.find() ? Optional.of(matcher) : Optional.empty();
            }
            if (!result.isPresent()) {
                lineReader.pushLineBack(line);
            }
            return result;
        }
    }
    ,
    SVN(DiffMatcher.FROM_HEADER, HashMatchType.COMMIT){

        @Override
        protected void preLoop(String line, ReaderLineReader lineReader) {
            lineReader.pushLineBack(line);
        }

        @Override
        @Nonnull
        Either<DiffHeaderParserSectionResult, SectionHeader> getSection(String line, ReaderLineReader lineReader) throws IOException {
            if (StringUtils.chomp((String)line).isEmpty()) {
                String nextLine = lineReader.readLine();
                if (nextLine != null && nextLine.startsWith("Property changes on:")) {
                    return Either.left((Object)((Object)DiffHeaderParserSectionResult.SKIPPABLE_SECTION));
                }
                lineReader.pushLineBack(nextLine);
            }
            return super.getSection(line, lineReader);
        }
    };

    Pattern pattern;
    private final boolean singleLineHeader;
    private final HashMatchType hashMatchType;

    private DiffHeaderParser(Pattern pattern) {
        this(pattern, false);
    }

    private DiffHeaderParser(Pattern pattern, HashMatchType hashMatchType) {
        this(pattern, false, hashMatchType);
    }

    private DiffHeaderParser(Pattern pattern, boolean singleLineHeader) {
        this(pattern, singleLineHeader, (HashMatchType)null);
    }

    private DiffHeaderParser(Pattern pattern, boolean singleLineHeader, HashMatchType hashMatchType) {
        this.pattern = pattern;
        this.singleLineHeader = singleLineHeader;
        this.hashMatchType = hashMatchType;
    }

    public boolean matches(String line) {
        Matcher matcher = this.pattern.matcher(line);
        return matcher.find();
    }

    public DiffHeader parseHeaders(String line, ReaderLineReader lineReader) throws IOException {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.find()) {
            String fromRev = this.getFromRev(matcher);
            String toRev = this.getToRev(matcher);
            String fromPath = this.getFromPath(matcher);
            String toPath = this.getToPath(matcher);
            if (this.singleLineHeader) {
                RevisionHeader from = new RevisionHeader(fromPath, fromRev, false);
                RevisionHeader to = new RevisionHeader(toPath, toRev, false);
                if (AppConfig.Hacks.LENIENT_PATCHES) {
                    line = lineReader.readLine();
                    while (line != null && (line.startsWith("---") || line.startsWith("+++"))) {
                        line = lineReader.readLine();
                    }
                    if (line != null) {
                        lineReader.pushLineBack(line);
                    }
                }
                return new DiffHeader(from, to, this);
            }
            this.preLoop(line, lineReader);
            while ((line = lineReader.readLine()) != null) {
                RevisionHeader to;
                RevisionHeader from = DiffMatcher.matchHeader(true, line);
                if (from == null || (line = lineReader.readLine()) == null || (to = DiffMatcher.matchHeader(false, line)) == null) continue;
                if (fromRev != null) {
                    from.setRevision(fromRev);
                    from.setHashMatchType(this.hashMatchType);
                }
                if (toRev != null) {
                    to.setRevision(toRev);
                    to.setHashMatchType(this.hashMatchType);
                }
                return new DiffHeader(from, to, this);
            }
        }
        return null;
    }

    protected void preLoop(String line, ReaderLineReader lineReader) {
    }

    @Nonnull
    Either<DiffHeaderParserSectionResult, SectionHeader> getSection(String line, ReaderLineReader lineReader) throws IOException {
        SectionHeader section = DiffMatcher.matchSection(line);
        if (section == null) {
            if (AppConfig.Hacks.LENIENT_PATCHES && line.startsWith("+")) {
                int lineCount = 0;
                LinkedList<String> lineBuffer = new LinkedList<String>();
                while (line != null && line.startsWith("+")) {
                    lineBuffer.add(line);
                    ++lineCount;
                    line = lineReader.readLine();
                }
                while (!lineBuffer.isEmpty()) {
                    lineReader.pushLineBack((String)lineBuffer.removeLast());
                }
                return Either.right((Object)new SectionHeader(0, 0, 1, lineCount));
            }
            lineReader.pushLineBack(line);
            return Either.left((Object)((Object)DiffHeaderParserSectionResult.NO_SECTION));
        }
        return Either.right((Object)section);
    }

    String getFromRev(Matcher matcher) {
        return null;
    }

    String getToRev(Matcher matcher) {
        return null;
    }

    String getFromPath(Matcher matcher) {
        return null;
    }

    String getToPath(Matcher matcher) {
        return null;
    }
}

