/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffListener;
import com.cenqua.fisheye.Path;
import java.util.ArrayList;
import java.util.List;

public class DiffDirectoryListener
implements UnifiedDiffListener {
    private List<DiffRevisionsInfo> files = new ArrayList<DiffRevisionsInfo>();
    private RevisionHeader fromHeader;
    private RevisionHeader toHeader;
    private boolean areHeadersSet;
    private int idx = 0;

    public List<DiffRevisionsInfo> list() {
        return this.files;
    }

    @Override
    public void fromHeader(RevisionHeader header) {
        if (this.areHeadersSet) {
            this.createDRI(0, 0);
        }
        this.fromHeader = header;
    }

    @Override
    public void toHeader(RevisionHeader header) {
        this.toHeader = header;
        this.areHeadersSet = true;
    }

    @Override
    public void section(int fromLine, int numFromLines, int toLine, int numToLines) {
        if (this.areHeadersSet) {
            this.createDRI(numFromLines, numToLines);
        }
    }

    @Override
    public void addLine(String line) {
    }

    @Override
    public void contextLine(String line) {
    }

    @Override
    public void removeLine(String line) {
    }

    @Override
    public void eof() {
        if (this.areHeadersSet) {
            this.createDRI(0, 0);
        }
    }

    protected void createDRI(int numFromLines, int numToLines) {
        DiffRevisionsInfo dri = new DiffRevisionsInfo();
        dri.setFromLines(numFromLines);
        dri.setToLines(numToLines);
        if (this.fileAdded(numFromLines)) {
            dri.setPath(new Path(this.toHeader.getPath()));
            if (numFromLines > 0) {
                dri.setFromPath(new Path(this.fromHeader.getPath()));
            }
            dri.setFromRevisionName(null);
        } else if (this.fileDeleted(numToLines)) {
            dri.setPath(new Path(this.fromHeader.getPath()));
            dri.setFromRevisionName(this.fromHeader.getRevision());
            dri.setDeleted(true);
        } else {
            dri.setPath(new Path(this.fromHeader.getPath()));
            dri.setFromRevisionName(this.fromHeader.getRevision());
            dri.setFromRevisionType(this.fromHeader.getHashMatchType());
        }
        dri.setIndex(this.idx++);
        this.files.add(dri);
        this.areHeadersSet = false;
    }

    private boolean fileDeleted(int numToLines) {
        return this.toHeader.isNullRev() || this.fromHeader.getRevision().equals(this.toHeader.getRevision()) && numToLines == 0;
    }

    private boolean fileAdded(int numFromLines) {
        return this.fromHeader.isNullRev() || this.fromHeader.getRevision().equals(this.toHeader.getRevision()) && numFromLines == 0;
    }
}

