/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.patchDiff;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.revision.diff.patchDiff.PatchDiffListener;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.patchDiff.PatchSectionView;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffParser;
import com.cenqua.crucible.revision.source.PatchRevision;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.util.Pair;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class PatchDiff {
    private final CrucibleRevision toRevision;
    private PatchDiffListener pdl;
    private LinkedList<PatchSectionView> sections;
    private final Patch patch;
    private final SyntaxDefinition syntaxDefinition;

    public PatchDiff(CrucibleRevision toRevision, Patch patch, SyntaxDefinition syntaxDefinition) {
        this.toRevision = toRevision;
        this.patch = patch;
        this.syntaxDefinition = syntaxDefinition;
    }

    public List<PatchSectionView> getSectionViews(int context) throws PatchException {
        this.sections = new LinkedList();
        List<PatchDiffListener.Sect> sects = this.getPatchDiffListener().getSects();
        PatchDiffListener.Sect lastSect = null;
        int sectsLeft = sects.size();
        for (PatchDiffListener.Sect sect : sects) {
            RegionList toSyntaxHighlightRegions;
            RegionList fromSyntaxHighlightRegions;
            --sectsLeft;
            if (context != -1 && sect.isCommon()) {
                if (context > 0) {
                    if (lastSect == null) {
                        this.addLastContextLines(sect, context, false);
                    } else if (sect.getToLinesCount() > (sectsLeft > 0 ? 2 * context : context)) {
                        this.addFirstContextLines(sect, context);
                        if (sectsLeft > 0) {
                            this.addLastContextLines(sect, context, true);
                        }
                    } else {
                        fromSyntaxHighlightRegions = this.createRegionList(sect.getFromLines());
                        toSyntaxHighlightRegions = this.createRegionList(sect.getToLines());
                        this.sections.add(new PatchSectionView(sect, fromSyntaxHighlightRegions, toSyntaxHighlightRegions));
                    }
                }
            } else {
                fromSyntaxHighlightRegions = this.createRegionList(sect.getFromLines());
                toSyntaxHighlightRegions = this.createRegionList(sect.getToLines());
                boolean gap = context == 0 && sectsLeft != 0 && this.sections.size() != 0 || sect.isGap();
                this.sections.add(new PatchSectionView(this.copySection(sect, gap), fromSyntaxHighlightRegions, toSyntaxHighlightRegions));
            }
            lastSect = sect;
        }
        return this.sections;
    }

    public Pair<Integer, Integer> getLinesAddedRemoved() throws PatchException {
        List<PatchDiffListener.Sect> sects = this.getPatchDiffListener().getSects();
        int added = 0;
        int removed = 0;
        for (PatchDiffListener.Sect sect : sects) {
            if (sect.isCommon()) continue;
            added += sect.getToLinesCount();
            removed += sect.getFromLinesCount();
        }
        return Pair.newInstance(added, removed);
    }

    private void addLastContextLines(PatchDiffListener.Sect sect, int context, boolean gap) {
        int toEnd = sect.getFirstToLineNumber() + sect.getToLinesCount() - 1;
        int toLine = sect.getToLinesCount() > context ? sect.getFirstToLineNumber() + sect.getToLinesCount() - context : sect.getFirstToLineNumber();
        int fromLine = sect.getFromLinesCount() > context ? sect.getFirstFromLineNumber() + sect.getFromLinesCount() - context : sect.getFirstFromLineNumber();
        this.addContextLines(sect, toEnd, toLine, fromLine, gap);
    }

    private void addFirstContextLines(PatchDiffListener.Sect sect, int context) {
        int toEnd = sect.getToLinesCount() > context ? sect.getFirstToLineNumber() + context - 1 : sect.getFirstToLineNumber() + (sect.getToLinesCount() - 1);
        int toLine = sect.getFirstToLineNumber();
        int fromLine = sect.getFirstFromLineNumber();
        this.addContextLines(sect, toEnd, toLine, fromLine, false);
    }

    private void addContextLines(PatchDiffListener.Sect sect, int toEnd, int toLine, int fromLine, boolean gap) {
        PatchDiffListener.Sect tmpSect = new PatchDiffListener.Sect(sect.isCommon(), gap);
        while (toLine <= toEnd) {
            tmpSect.addLine(sect.getToLine(toLine).toString(), toLine++, fromLine++, false);
        }
        RegionList fromSyntaxHighlightRegions = this.createRegionList(tmpSect.getFromLines());
        RegionList toSyntaxHighlightRegions = this.createRegionList(tmpSect.getToLines());
        this.sections.add(new PatchSectionView(tmpSect, fromSyntaxHighlightRegions, toSyntaxHighlightRegions));
    }

    private PatchDiffListener.Sect copySection(PatchDiffListener.Sect sect, boolean gap) {
        PatchDiffListener.Sect tmpSect = new PatchDiffListener.Sect(sect.isCommon(), gap);
        if (sect.isCommon()) {
            int fromLine = sect.getFirstFromLineNumber();
            int toLine = sect.getFirstToLineNumber();
            int stop = sect.getFirstFromLineNumber() + sect.getFromLinesCount() - 1;
            while (fromLine <= stop) {
                tmpSect.addLine(sect.getFromLine(fromLine).toString(), toLine++, fromLine++, false);
            }
        } else {
            int line = sect.getFirstFromLineNumber();
            int stop = sect.getFirstFromLineNumber() + sect.getFromLinesCount() - 1;
            while (line <= stop) {
                tmpSect.addLine(sect.getFromLine(line).toString(), 0, line++, false);
            }
            line = sect.getFirstToLineNumber();
            stop = sect.getFirstToLineNumber() + sect.getToLinesCount() - 1;
            while (line <= stop) {
                tmpSect.addLine(sect.getToLine(line).toString(), line++, 0, true);
            }
        }
        return tmpSect;
    }

    private RegionList createRegionList(StringBuilder text) {
        RegionList regions = new RegionList();
        this.syntaxDefinition.generateRegions(new InputState(text), regions);
        return regions;
    }

    private PatchDiffListener getPatchDiffListener() throws PatchException {
        if (this.pdl == null) {
            this.pdl = this.process();
        }
        return this.pdl;
    }

    private PatchDiffListener process() throws PatchException {
        PatchDiffListener patchDiffListener;
        ReaderLineReader lineReader = null;
        try {
            UnifiedDiffParser parser = new UnifiedDiffParser();
            lineReader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getPatchFile()), this.getPatchCharset())));
            PatchDiffListener pdl = new PatchDiffListener();
            PatchRevision patchRevision = PatchRevision.fromCrucibleRevision(this.toRevision);
            parser.processRevision(lineReader, pdl, patchRevision.driIndex);
            if (pdl.getFromPath().isEmpty()) {
                Logs.APP_LOG.warn((Object)String.format("Failed to find requested diff %s", patchRevision.driIndex));
            }
            patchDiffListener = pdl;
        }
        catch (Exception e2) {
            try {
                throw new PatchException(e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(new Closeable[]{lineReader});
                throw throwable;
            }
        }
        IOHelper.close(new Closeable[]{lineReader});
        return patchDiffListener;
    }

    private File getPatchFile() {
        return this.patch.getPatchFile();
    }

    private String getPatchCharset() {
        return this.patch.getUploadItem().getCharset() == null ? "UTF-8" : this.patch.getUploadItem().getCharset();
    }
}

