/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff;

import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.fisheye.Path;
import com.google.common.base.Objects;

public class DiffRevisionsInfo {
    private Path path;
    private Path fromPath;
    private String fromRevisionName;
    private HashMatchType fromRevisionType;
    private int index = -1;
    private int fromLines = 0;
    private int toLines = 0;
    private boolean deleted;

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getFromPath() {
        return this.fromPath;
    }

    public void setFromPath(Path fromPath) {
        this.fromPath = fromPath;
    }

    public String getFromRevisionName() {
        if (this.isCopied() && this.fromRevisionName == null) {
            return "copy source";
        }
        return this.fromRevisionName;
    }

    public HashMatchType getFromRevisionType() {
        return this.fromRevisionType;
    }

    public int getFromLines() {
        return this.fromLines;
    }

    public int getToLines() {
        return this.toLines;
    }

    public void setFromRevisionName(String fromRevisionName) {
        this.fromRevisionName = fromRevisionName;
    }

    public void setFromRevisionType(HashMatchType type) {
        this.fromRevisionType = type;
    }

    public static String getToRevisionName(int iteration) {
        return String.format("iteration #%s", iteration);
    }

    public void setFromLines(int fromLines) {
        this.fromLines = fromLines;
    }

    public void setToLines(int toLines) {
        this.toLines = toLines;
    }

    public boolean isAdded() {
        return this.fromLines == 0 && this.fromRevisionName == null;
    }

    public boolean isDeleted() {
        return this.deleted && this.fromRevisionName != null;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isChanged() {
        return !this.deleted && this.fromRevisionName != null;
    }

    public boolean isCopied() {
        return !this.isDeleted() && !this.isAdded() && this.fromPath != null && !this.fromPath.equals(this.path);
    }

    public boolean isMoved() {
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DiffRevisionsInfo that = (DiffRevisionsInfo)o2;
        if (this.fromLines != that.fromLines) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.toLines != that.toLines) {
            return false;
        }
        if (this.fromRevisionName != null ? !this.fromRevisionName.equals(that.fromRevisionName) : that.fromRevisionName != null) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        return Objects.equal((Object)this.deleted, (Object)that.deleted);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (this.fromRevisionName != null ? this.fromRevisionName.hashCode() : 0);
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.deleted});
        result = 31 * result + this.index;
        result = 31 * result + this.fromLines;
        result = 31 * result + this.toLines;
        return result;
    }

    public String toString() {
        return "(" + this.index + ")" + this.path.toString() + " (" + this.getFromRevisionName() + ")" + "@@ " + this.fromLines + "," + this.toLines;
    }
}

