/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileRevisionInfo {
    private final Map<String, String> details;
    private final String revision;
    private final String revisionDisplayName;
    private final String path;

    public FileRevisionInfo(String path, String revision, String revisionDisplayName, Map<String, String> details) {
        this.details = details;
        this.revision = revision;
        this.revisionDisplayName = revisionDisplayName;
        this.path = path;
    }

    public FileRevisionInfo(String branch, RevInfoKey diffRevision, String revision, String revisionDisplayName, String author, String path, Date commitDate, String commitComment, boolean deleted, boolean binary, boolean directory, boolean annotatable, boolean added, boolean modified, boolean moved, boolean copied, Integer linesAdded, Integer linesRemoved, boolean oversize) {
        this.details = new HashMap<String, String>();
        this.revision = revision;
        this.revisionDisplayName = revisionDisplayName;
        this.path = path;
        this.putDetail("branch", branch);
        if (diffRevision != null) {
            this.putDetail("diffRevision", diffRevision.getRev());
            this.putDetail("diffPath", diffRevision.getPath().getPath());
        }
        this.putDetail("commit_date", commitDate);
        this.putDetail("author", author);
        this.putDetail("comment", commitComment);
        this.putDetail("binary", binary);
        this.putDetail("filetype", directory ? "dir" : "file");
        this.putDetail("annotatable", annotatable);
        this.putDetail("deleted", deleted);
        this.putDetail("added", added);
        this.putDetail("modified", modified);
        this.putDetail("moved", moved);
        this.putDetail("copied", copied);
        this.putDetail("linesAdded", linesAdded);
        this.putDetail("linesRemoved", linesRemoved);
        this.putDetail("oversize", oversize);
    }

    private void putDetail(String key, String value) {
        if (value != null) {
            this.details.put(key, value);
        }
    }

    private void putDetail(String key, Integer value) {
        if (value != null) {
            this.details.put(key, value.toString());
        }
    }

    private void putDetail(String key, boolean value) {
        this.details.put(key, String.valueOf(value));
    }

    private void putDetail(String key, Date value) {
        if (value != null) {
            this.details.put(key, String.valueOf(value.getTime()));
        }
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public String toString() {
        return this.details.toString();
    }

    public String getRevision() {
        return this.revision;
    }

    public String getRevisionDisplayName() {
        return this.revisionDisplayName;
    }

    public String getPath() {
        return this.path;
    }

    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(new Path(this.path), this.revision);
    }
}

