/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StateCountCache {
    private static StateCountCache instance;
    private final Map<StateCountKey, Long> cache = new HashMap<StateCountKey, Long>();
    private Date lastExpired = new Date(0L);

    private static StateCountCache getInstance() {
        if (instance == null) {
            instance = new StateCountCache();
        }
        return instance;
    }

    public static void put(Date date, String stateName, String project, long count) {
        StateCountCache.getInstance().put_(date, stateName, project, count);
    }

    public static Long get(Date date, String stateName, String project) {
        return StateCountCache.getInstance().get_(date, stateName, project);
    }

    public static void expireOlderThan(Date date) {
        StateCountCache.getInstance().expireOlderThan_(date);
    }

    public static void flush() {
        StateCountCache.getInstance().flush_();
    }

    private StateCountCache() {
    }

    private synchronized void flush_() {
        this.lastExpired = new Date(0L);
        this.cache.clear();
    }

    private synchronized void put_(Date date, String stateName, String project, long count) {
        this.cache.put(new StateCountKey(date, stateName, project), count);
    }

    private synchronized Long get_(Date date, String stateName, String project) {
        return this.cache.get(new StateCountKey(date, stateName, project));
    }

    private synchronized void expireOlderThan_(Date date) {
        if (this.lastExpired.before(date)) {
            this.lastExpired = date;
            Iterator<Map.Entry<StateCountKey, Long>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<StateCountKey, Long> k2 = iterator.next();
                if (!k2.getKey().date.before(date)) continue;
                iterator.remove();
            }
        }
    }

    private static class StateCountKey {
        Date date;
        String state;
        String project;

        private StateCountKey(Date date, String state, String project) {
            this.date = date;
            this.state = state;
            this.project = project;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            StateCountKey that = (StateCountKey)o2;
            return this.date.equals(that.date) && this.project.equals(that.project) && this.state.equals(that.state);
        }

        public int hashCode() {
            int result = this.date.hashCode();
            result = 31 * result + this.state.hashCode();
            result = 31 * result + this.project.hashCode();
            return result;
        }
    }
}

