/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.reviews.StateCountCache;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.DateHelper;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;

public class ReviewsDatasetMaker {
    private DefaultTableXYDataset reviewDataSet;
    private Period period;
    private String stateName;
    private Project project;
    private long maxReviews;
    private long openReviews;
    private final ReviewManager reviewManager;

    public ReviewsDatasetMaker(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
        this.period = new Period();
        this.period.lastWeek();
        this.stateName = "Review";
        this.maxReviews = 0L;
        this.openReviews = 0L;
    }

    public ReviewsDatasetMaker(ReviewManager reviewManager, Date from, Date to, String stateName, Project project) {
        this.reviewManager = reviewManager;
        this.period = new Period();
        this.period.setTo(DateHelper.getEndOfDay(to, AppConfig.getsConfig().getTimezone()));
        this.period.setFrom(DateHelper.getStartOfDay(from, AppConfig.getsConfig().getTimezone()));
        this.stateName = stateName;
        this.project = project;
    }

    public TableXYDataset getDataSet() {
        if (this.reviewDataSet == null) {
            this.makeDataset(6);
        }
        return this.reviewDataSet;
    }

    private void makeDataset(int interval) {
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        this.reviewDataSet = new DefaultTableXYDataset();
        XYSeries s1 = new XYSeries((Comparable)((Object)this.stateName), true, false);
        StateCountCache.expireOlderThan(this.period.getFrom());
        int i2 = 0;
        cal.setTime(this.period.getFrom());
        while (this.period.getTo().compareTo(cal.getTime()) > 0) {
            Long count;
            Long l2 = count = cal.getTime().after(now) ? null : StateCountCache.get(cal.getTime(), this.stateName, this.project.getProjKey());
            if (count == null) {
                Map<String, Long> stateCounts = this.reviewManager.countStatesOn(cal.getTime(), this.project);
                count = stateCounts.get(this.stateName) == null ? Long.valueOf(0L) : stateCounts.get(this.stateName);
                StateCountCache.put(cal.getTime(), this.stateName, this.project.getProjKey(), count);
            }
            s1.add((double)i2++, (Number)count);
            if (count > this.maxReviews) {
                this.maxReviews = count;
            }
            this.openReviews = count;
            cal.add(interval, 1);
        }
        this.reviewDataSet.addSeries(s1);
    }

    public long getMaxReviews() {
        return this.maxReviews;
    }

    public long getOpenReviews() {
        return this.openReviews;
    }
}

