/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import com.atlassian.crucible.actions.project.ReviewAgeBucket;
import com.atlassian.crucible.actions.project.ReviewAgeBucketSegment;
import com.atlassian.crucible.actions.project.ReviewAgeBuckets;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ReviewAgeDatasetMaker {
    private DefaultCategoryDataset ageDataSet;
    private Project project;

    public ReviewAgeDatasetMaker(Project project) {
        this.project = project;
    }

    public CategoryDataset getDataSet() {
        if (this.ageDataSet == null) {
            this.makeDataset(this.project);
        }
        return this.ageDataSet;
    }

    public Project getProject() {
        return this.project;
    }

    private void makeDataset(Project project) {
        this.ageDataSet = new DefaultCategoryDataset();
        ReviewAgeBuckets ageBuckets = new ReviewAgeBuckets(project, DefaultReviewManager.get());
        for (ReviewAgeBucket bucket : ageBuckets.getBuckets()) {
            if (!bucket.isNoReviews()) {
                for (ReviewAgeBucketSegment segment : bucket.getSegments()) {
                    this.ageDataSet.addValue((double)segment.getCount(), (Comparable)((Object)segment.getName()), (Comparable)((Object)bucket.getDescription()));
                }
                continue;
            }
            this.ageDataSet.addValue(0.0, (Comparable)((Object)"Review"), (Comparable)((Object)bucket.getDescription()));
        }
    }
}

