/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.commentsDefects;

import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import java.util.List;
import org.jfree.data.general.DefaultPieDataset;

public class DefectRepDatasetMaker {
    private final CommentManager commentManager;
    private final CommentSearchData sd;
    private final String metric;
    private DefaultPieDataset defectDataSet;

    public DefectRepDatasetMaker(CommentManager commentManager, CommentSearchData sd, String metric) {
        this.commentManager = commentManager;
        this.sd = sd;
        this.metric = metric;
    }

    public DefaultPieDataset getPieDataSet() {
        if (this.defectDataSet == null) {
            this.makePieDataset();
        }
        return this.defectDataSet;
    }

    private void makePieDataset() {
        this.defectDataSet = new DefaultPieDataset();
        if (!this.sd.isDefects() && this.sd.isComments()) {
            return;
        }
        this.sd.setComments(false);
        this.sd.setDefects(true);
        List<DefectReportDO> defectReports = this.commentManager.getDefectReports(this.sd, this.metric);
        for (DefectReportDO dr : defectReports) {
            this.defectDataSet.setValue((Comparable)((Object)dr.getLabel()), (Number)dr.getCount());
        }
    }
}

