/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.commentsDefects;

import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.reports.ChartColours;
import com.cenqua.crucible.reports.IntervalTickUnitSource;
import com.cenqua.crucible.reports.commentsDefects.CommentDatasetMaker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.HorizontalAlignment;

public class CommentChart {
    private final CommentManager commentManager;

    public CommentChart(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public String getImageContentType() {
        return "image/png";
    }

    public void getRenderChart(OutputStream out, int width, int height, Date from, Date to, Project project) throws IOException {
        CommentDatasetMaker cdm = new CommentDatasetMaker(from, to, project, this.commentManager);
        JFreeChart chart = this.createChart("", cdm.getDataSet(), "", "");
        BufferedImage image = chart.createBufferedImage(width, height);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
    }

    public JFreeChart createChart(String chartTitle, CategoryDataset barData, String valueName, String xAxisName) {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)chartTitle, (String)xAxisName, (String)valueName, (CategoryDataset)barData, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setTextAntiAlias(true);
        TextTitle title = chart.getTitle();
        title.setTextAlignment(HorizontalAlignment.LEFT);
        title.setPaint((Paint)Color.WHITE);
        title.setBackgroundPaint((Paint)Color.DARK_GRAY);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.setOutlineVisible(false);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setAutoRangeMinimumSize(10.0);
        valueAxis.setLowerBound(0.0);
        valueAxis.setAxisLinePaint((Paint)Color.LIGHT_GRAY);
        valueAxis.setTickMarksVisible(false);
        valueAxis.setTickLabelPaint((Paint)Color.LIGHT_GRAY);
        valueAxis.setStandardTickUnits((TickUnitSource)new IntervalTickUnitSource(5.0));
        valueAxis.setAxisLineVisible(false);
        CategoryAxis catAxis = plot.getDomainAxis();
        catAxis.setLowerMargin(0.1);
        catAxis.setCategoryMargin(0.0);
        catAxis.setUpperMargin(0.1);
        catAxis.setTickLabelsVisible(false);
        BasicStroke stroke = new BasicStroke(1.0f);
        catAxis.setAxisLineStroke((Stroke)stroke);
        catAxis.setAxisLinePaint((Paint)Color.LIGHT_GRAY);
        StackedBarRenderer renderer = (StackedBarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(true);
        renderer.setSeriesPaint(1, (Paint)ChartColours.defectRed);
        renderer.setSeriesPaint(0, (Paint)ChartColours.commentBlue);
        renderer.setBaseOutlinePaint((Paint)Color.WHITE);
        renderer.setItemMargin(0.0);
        return chart;
    }
}

