/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import com.atlassian.crucible.actions.chart.SparkLineCalculator;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.SparkLineResult;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SparkLineResultCache {
    private static final long MAX_RESULT_AGE_MILLIS = 600000L;
    private final ReviewManager reviewManager;
    private Map<Key, Result> cache = new ConcurrentHashMap<Key, Result>();

    @Autowired
    public SparkLineResultCache(ReviewManager reviewManager) {
        this.reviewManager = reviewManager;
    }

    public void precalculate(Project project, Date from, Date to, final List<? extends SparkLineCalculator> calculators) {
        this.reviewManager.processLogRecords(from, to, project, new LogRecordProcessor(){

            @Override
            public void handle(StateChangeLog log) {
                for (SparkLineCalculator c2 : calculators) {
                    c2.getLogRecordProcessor().handle(log);
                }
            }

            @Override
            public void afterFinalRecord() {
                for (SparkLineCalculator c2 : calculators) {
                    c2.getLogRecordProcessor().afterFinalRecord();
                }
            }

            @Override
            public double[] getData() {
                throw new NoSuchMethodError();
            }

            @Override
            public double getSummary() {
                throw new NoSuchMethodError();
            }

            @Override
            public boolean calculationsComplete() {
                throw new NoSuchMethodError();
            }
        });
        for (SparkLineCalculator sparkLineCalculator : calculators) {
            this.cache.put(new Key(project, from, to, sparkLineCalculator.getClass()), new Result(sparkLineCalculator.getResult(), System.currentTimeMillis()));
        }
    }

    public boolean contains(Project project, Date from, Date to, SparkLineCalculator calculator) {
        Key key = new Key(project, from, to, calculator.getClass());
        Result result = this.cache.get(key);
        return result != null && System.currentTimeMillis() - result.calculationDate <= 600000L;
    }

    public SparkLineResult get(Project project, Date from, Date to, SparkLineCalculator calculator) {
        Key key = new Key(project, from, to, calculator.getClass());
        Result result = this.cache.get(key);
        if (result == null || System.currentTimeMillis() - result.calculationDate > 600000L) {
            this.reviewManager.processLogRecords(from, to, project, calculator.getLogRecordProcessor());
            result = new Result(calculator.getResult(), System.currentTimeMillis());
            this.cache.put(key, result);
        }
        return result.result;
    }

    private static class Result {
        SparkLineResult result;
        long calculationDate;

        public Result(SparkLineResult result, long calculationDate) {
            this.result = result;
            this.calculationDate = calculationDate;
        }
    }

    private static class Key {
        String projectKey;
        Date to;
        Class calculatorClass;
        private final Date from;

        public Key(Project project, Date from, Date to, Class calculatorClass) {
            this.from = from;
            this.projectKey = project.getProjKey();
            this.to = to;
            this.calculatorClass = calculatorClass;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Key key = (Key)o2;
            if (this.calculatorClass != null ? !this.calculatorClass.equals(key.calculatorClass) : key.calculatorClass != null) {
                return false;
            }
            if (this.from != null ? !this.from.equals(key.from) : key.from != null) {
                return false;
            }
            if (this.projectKey != null ? !this.projectKey.equals(key.projectKey) : key.projectKey != null) {
                return false;
            }
            return !(this.to != null ? !this.to.equals(key.to) : key.to != null);
        }

        public int hashCode() {
            int result = this.projectKey != null ? this.projectKey.hashCode() : 0;
            result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
            result = 31 * result + (this.calculatorClass != null ? this.calculatorClass.hashCode() : 0);
            result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
            return result;
        }
    }
}

