/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import com.google.common.collect.TreeMultimap;
import java.util.Iterator;
import org.jfree.data.general.DefaultPieDataset;

public class PieDatasetAdjuster {
    public static DefaultPieDataset adjustPieDataset(DefaultPieDataset data, int maxSegments, double minSegmentSize) {
        double segmentSize;
        DefaultPieDataset newDs = new DefaultPieDataset();
        TreeMultimap segmentsBySize = TreeMultimap.create();
        double totalValues = 0.0;
        double otherSize = 0.0;
        for (Iterator c2 : data.getKeys()) {
            totalValues += data.getValue((Comparable)((Object)c2)).doubleValue();
            segmentsBySize.put((Object)(-data.getValue((Comparable)((Object)c2)).doubleValue()), c2);
        }
        int tooSmallCount = 0;
        for (Object c3 : data.getKeys()) {
            segmentSize = data.getValue((Comparable)c3).doubleValue();
            if (!(segmentSize / totalValues < minSegmentSize / 100.0)) continue;
            ++tooSmallCount;
        }
        if (tooSmallCount > 1) {
            for (Object c3 : data.getKeys()) {
                segmentSize = data.getValue((Comparable)c3).doubleValue();
                if (!(segmentSize / totalValues < minSegmentSize / 100.0)) continue;
                otherSize += segmentSize;
                PieDatasetAdjuster.removeByValue((TreeMultimap<Double, Comparable>)segmentsBySize, (Comparable)c3);
            }
        }
        if (maxSegments > 0 && segmentsBySize.size() > maxSegments + 1 || otherSize > 0.0) {
            int count = 0;
            for (Comparable v2 : segmentsBySize.values()) {
                if (count++ < maxSegments) {
                    newDs.setValue(v2, data.getValue(v2));
                    continue;
                }
                otherSize += data.getValue(v2).doubleValue();
            }
        } else {
            for (Comparable v3 : segmentsBySize.values()) {
                newDs.setValue(v3, data.getValue(v3));
            }
        }
        if (otherSize > 0.0) {
            newDs.setValue((Comparable)((Object)"Other"), otherSize);
        }
        return newDs;
    }

    public static DefaultPieDataset addPercentToLabels(DefaultPieDataset data) {
        DefaultPieDataset newDs = new DefaultPieDataset();
        if (data.getItemCount() > 0) {
            double totalValues = 0.0;
            for (Comparable c2 : data.getKeys()) {
                totalValues += data.getValue(c2).doubleValue();
            }
            Comparable lastDr = (Comparable)data.getKeys().get(data.getItemCount() - 1);
            int percentSum = 0;
            for (Comparable c3 : data.getKeys()) {
                int percent = 0;
                if (totalValues != 0.0) {
                    if (c3 != lastDr && percentSum < 100) {
                        percent = (int)Math.round(data.getValue(c3).doubleValue() / totalValues * 100.0);
                        percentSum += percent;
                    } else {
                        percent = 100 - percentSum;
                    }
                }
                String label = String.format("%d%% %s", percent, c3);
                newDs.setValue((Comparable)((Object)label), data.getValue(c3).doubleValue());
            }
        }
        return newDs;
    }

    private static void removeByValue(TreeMultimap<Double, Comparable> map, Comparable v2) {
        for (Double key : map.keySet()) {
            if (!map.remove((Object)key, (Object)v2)) continue;
            return;
        }
    }
}

