/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import com.cenqua.crucible.reports.ChartColours;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedString;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;

public class PieChart {
    private static final int MAX_LABEL_LENGTH = 20;
    protected static final int LEGEND_ITEM_HEIGHT = 24;

    public String getImageContentType() {
        return "image/png";
    }

    public static int getLegendItemHeight() {
        return 24;
    }

    public void renderChart(OutputStream out, int width, int height, JFreeChart chart) throws IOException {
        BufferedImage image = chart.createBufferedImage(width, height);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
    }

    public JFreeChart createChart(String chartTitle, DefaultPieDataset data, boolean showLegend) {
        JFreeChart chart = ChartFactory.createPieChart((String)chartTitle, (PieDataset)data, (boolean)true, (boolean)false, (boolean)false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setStartAngle(290.0);
        plot.setDirection(Rotation.CLOCKWISE);
        plot.setNoDataMessage("No data to display");
        plot.setLabelGenerator(null);
        plot.setCircular(true);
        plot.setIgnoreNullValues(true);
        plot.setIgnoreZeroValues(true);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setOutlineVisible(false);
        if (data.getItemCount() > 1) {
            plot.setBaseSectionOutlinePaint((Paint)Color.WHITE);
            plot.setBaseSectionOutlineStroke((Stroke)new BasicStroke(1.0f));
        } else {
            Ellipse2D c2 = (Ellipse2D)plot.getLegendItemShape();
            double s2 = c2.getWidth() - 2.0;
            plot.setLegendItemShape((Shape)new Ellipse2D.Double(0.0, 0.0, s2, s2));
            plot.setSectionOutlinesVisible(false);
        }
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        int i2 = 0;
        for (Comparable c3 : data.getKeys()) {
            if (i2 >= ChartColours.pieColours.length || data.getValue(c3).intValue() <= 0) continue;
            plot.setSectionPaint(c3, (Paint)ChartColours.pieColours[i2++]);
        }
        plot.setLegendLabelGenerator(new PieSectionLabelGenerator(){

            public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
                String s2 = (String)((Object)comparable);
                if (s2.length() > 20) {
                    return s2.substring(0, 19) + "\u2026";
                }
                return s2;
            }

            public AttributedString generateAttributedSectionLabel(PieDataset pieDataset, Comparable comparable) {
                return new AttributedString(this.generateSectionLabel(pieDataset, comparable));
            }
        });
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setTextAntiAlias(true);
        chart.setBorderVisible(false);
        TextTitle title = chart.getTitle();
        title.setTextAlignment(HorizontalAlignment.LEFT);
        title.setPaint((Paint)Color.DARK_GRAY);
        title.setBackgroundPaint((Paint)Color.WHITE);
        if (showLegend) {
            LegendTitle legend = chart.getLegend();
            legend.setBorder(0.0, 0.0, 0.0, 0.0);
            legend.setItemPaint((Paint)Color.GRAY);
            legend.setPosition(RectangleEdge.RIGHT);
        } else {
            chart.removeLegend();
        }
        return chart;
    }
}

