/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.DateHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Period {
    private Date to;
    private Date from;
    private TimeZone tz = AppConfig.getsConfig().getTimezone();
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:SS");
    private String description;
    public static final int HOURS = 10;
    public static final int DAYS = 6;
    public static final int WEEKS = 3;
    public static final int MONTHS = 2;

    public void lastMonth() {
        this.tMinus(1, 2);
        this.description = "month";
    }

    public void lastFortnight() {
        this.tMinus(2, 3);
        this.description = "fortnight";
    }

    public void lastWeek() {
        this.tMinus(1, 3);
        this.description = "week";
    }

    public void today() {
        Calendar cal = DateHelper.getStartOfTodayAsCalendar(this.tz);
        this.from = cal.getTime();
        cal.add(6, 1);
        this.to = cal.getTime();
        this.description = "day";
    }

    public void tMinus(int count, int units) {
        Calendar cal = DateHelper.getStartOfTodayAsCalendar(this.tz);
        cal.add(6, 1);
        this.to = cal.getTime();
        cal.add(units, -1 * count);
        this.from = cal.getTime();
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = DateHelper.age(this.from.getTime(), this.to.getTime());
        }
        return this.description;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public String getFromStr() {
        if (this.from != null) {
            return this.df.format(this.from);
        }
        return null;
    }

    public void setFromStr(String from) {
        this.from = new Date(DateHelper.parseDate(from, System.currentTimeMillis(), this.tz));
    }

    public String getToStr() {
        if (this.to != null) {
            return this.df.format(this.to);
        }
        return null;
    }

    public void setToStr(String to) {
        this.to = new Date(DateHelper.parseDate(to, System.currentTimeMillis(), this.tz));
    }
}

