/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import java.util.Date;
import java.util.GregorianCalendar;

public abstract class DailyDataSet {
    private final Date from;
    private final Date to;
    private static final long MILLISECONDS_PER_DAY = 86400000L;

    public DailyDataSet(Date from, Date to) {
        this.from = from;
        this.to = to;
    }

    public double[] getData() {
        GregorianCalendar cal = new GregorianCalendar();
        long days = (this.to.getTime() - this.from.getTime()) / 86400000L + 1L;
        double[] data = new double[(int)days];
        cal.setTime(this.from);
        int i2 = 0;
        while ((long)i2 < days) {
            data[i2] = this.getValue(cal.getTime());
            if ((long)i2 < days - 1L) {
                cal.add(6, 1);
            }
            ++i2;
        }
        if (!cal.getTime().equals(this.to)) {
            throw new RuntimeException("end date of loop doesn't match");
        }
        return data;
    }

    protected abstract double getValue(Date var1);
}

