/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.StateNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class StateChangeBatchCreator
extends AbstractBatchCreator {
    static final String TEMPLATE = "batch-state-note.ftl";

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        Review review;
        HashSet<Notification> notifications = new HashSet<Notification>();
        HashSet<Review> reviews = new HashSet<Review>();
        HashSet<FecruUser> actioners = new HashSet<FecruUser>();
        ArrayList<StateNotificationEvent> stateChanges = new ArrayList<StateNotificationEvent>();
        for (Notification r2 : notes) {
            StateNotificationEvent note;
            if (!(r2.getEvent() instanceof StateNotificationEvent) || (review = (note = (StateNotificationEvent)r2.getEvent()).getReview()) == null || review.getState().isDeadState()) continue;
            stateChanges.add(note);
            notifications.add(r2);
            reviews.add(review);
            actioners.add(note.getActioner());
        }
        if (notifications.isEmpty()) {
            return null;
        }
        Map<String, Object> attributes = FreemarkerUtil.init();
        attributes.put("stateChanges", stateChanges);
        attributes.put("review", notes.get(0).getEvent().getReview());
        String segment = this.emailTemplateRender.renderCrucibleTemplate(attributes, isHtml, TEMPLATE);
        FecruUser commonActioner = null;
        if (actioners.size() == 1) {
            commonActioner = (FecruUser)actioners.iterator().next();
        }
        review = (Review)reviews.iterator().next();
        return new Batch(this.emailTemplateRender.renderSubject(EmailThreadingHelper.buildSubjectForReview(review)), StateChangeBatchCreator.createSummary(review.getStateName()), segment, notifications, commonActioner, EmailThreadingHelper.buildThreadIdForReview(review));
    }

    protected static String createSummary(String commonState) {
        StringBuilder builder = new StringBuilder();
        builder.append("State changed");
        if (commonState != null) {
            builder.append(" to ").append(commonState);
        }
        return builder.toString();
    }

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return newNote instanceof StateNotificationEvent && (existing == null || existing.getReview().equals(newNote.getReview()));
    }
}

