/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.SharableContentType;
import com.cenqua.crucible.notification.ShareContentNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class ShareContentBatchCreator
extends AbstractBatchCreator {
    static final String TEMPLATE = "share-notification.ftl";

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return existing == null && newNote instanceof ShareContentNotificationEvent;
    }

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        String linkText;
        if (notes.size() > 1) {
            throw new IllegalStateException("Cannot batch share notifications");
        }
        Notification notification = notes.get(0);
        ShareContentNotificationEvent notificationEvent = (ShareContentNotificationEvent)notification.getEvent();
        HashSet<FecruUser> otherUsers = new HashSet<FecruUser>();
        Set otherNotifications = notificationEvent.getNotifications();
        HashSet<String> otherEmails = new HashSet<String>();
        for (Notification otherNote : otherNotifications) {
            FecruUser otherUser = otherNote.getUser();
            String otherEmailAddress = otherNote.getEmailAddress();
            if (otherUser != null) {
                if (otherUser.equals(notification.getUser())) continue;
                otherUsers.add(otherUser);
                continue;
            }
            if (otherEmailAddress == null || otherEmailAddress.equals(notification.getEmailAddress())) continue;
            otherEmails.add(otherEmailAddress);
        }
        Map<String, Object> attributes = FreemarkerUtil.init();
        if (StringUtils.isEmpty((String)notificationEvent.getObjectId())) {
            linkText = notificationEvent.getObjectName();
        } else if (notificationEvent.getObjectType() == SharableContentType.SOURCE) {
            linkText = notificationEvent.getObjectName() + " at " + notificationEvent.getObjectId();
        } else {
            linkText = notificationEvent.getObjectId();
            if (notificationEvent.getObjectName() != null && notificationEvent.getObjectName().trim().length() > 0) {
                linkText = linkText + ": " + notificationEvent.getObjectName();
            }
        }
        Share share = new Share(notificationEvent.getObjectUrl(), linkText, notificationEvent.getActioner(), otherUsers, otherEmails, notificationEvent.getObjectType().getSingular() + " " + notificationEvent.getObjectType().getName(), notificationEvent.getNote(), notificationEvent.getObjectRepository());
        attributes.put("share", share);
        attributes.put("notificationEvent", notificationEvent);
        String segment = this.emailTemplateRender.renderCrucibleTemplate(attributes, isHtml, TEMPLATE);
        return new Batch(this.emailTemplateRender.renderSubject(notificationEvent.getEmailSubject()), notificationEvent.getNote(), segment, notification, null);
    }

    public static class Share {
        private String url;
        private String linkText;
        private FecruUser from;
        private Set<FecruUser> otherUsers;
        private Set<String> otherEmails;
        private String message;
        private String typeDescription;
        private String repository;

        public Share(String url, String linkText, FecruUser from, Set<FecruUser> otherUsers, Set<String> otherEmails, String typeDescription, String message, String repository) {
            this.url = url;
            this.linkText = linkText;
            this.from = from;
            this.otherUsers = otherUsers;
            this.typeDescription = typeDescription;
            this.message = message;
            this.otherEmails = otherEmails;
            this.repository = repository;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLinkText() {
            return this.linkText;
        }

        public FecruUser getFrom() {
            return this.from;
        }

        public Set<FecruUser> getOtherUsers() {
            return this.otherUsers;
        }

        public Set<String> getOtherEmails() {
            return this.otherEmails;
        }

        public String getMessage() {
            return this.message;
        }

        public String getTypeDescription() {
            return this.typeDescription;
        }

        public String getRepository() {
            return this.repository;
        }
    }
}

