/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.RevisionAddedNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class RevisionAddedBatchCreator
extends AbstractBatchCreator {
    static final String TEMPLATE = "batch-revision-added-note.ftl";

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        HashSet<Notification> notifications = new HashSet<Notification>();
        HashSet<Review> reviews = new HashSet<Review>();
        HashSet<FecruUser> actioners = new HashSet<FecruUser>();
        final HashMap<String, HashSet<RevisionAddedNotificationEvent>> newRevisions = new HashMap<String, HashSet<RevisionAddedNotificationEvent>>();
        int revisionsAddedCount = 0;
        for (Notification notification : notes) {
            Review review;
            RevisionAddedNotificationEvent event;
            if (!(notification.getEvent() instanceof RevisionAddedNotificationEvent) || (event = (RevisionAddedNotificationEvent)notification.getEvent()).getFrx() == null || !event.getFrx().getFrxRevisions().contains(event.getFRXRevision()) || (review = event.getReview()) == null) continue;
            notifications.add(notification);
            reviews.add(review);
            actioners.add(event.getActioner());
            HashSet<RevisionAddedNotificationEvent> newFileRevs = (HashSet<RevisionAddedNotificationEvent>)newRevisions.get(event.getFrx().getPermaId());
            if (newFileRevs == null) {
                newFileRevs = new HashSet<RevisionAddedNotificationEvent>();
                newRevisions.put(event.getFrx().getPermaId(), newFileRevs);
            }
            if (!newFileRevs.add(event)) continue;
            ++revisionsAddedCount;
        }
        if (notifications.isEmpty()) {
            return null;
        }
        ArrayList<FileRevisionExtraInfo> orderedFrxs = new ArrayList<FileRevisionExtraInfo>();
        orderedFrxs.addAll(notes.get(0).getEvent().getReview().getFrxs());
        Collections.sort(orderedFrxs, new Comparator<FileRevisionExtraInfo>(){

            @Override
            public int compare(FileRevisionExtraInfo frx1, FileRevisionExtraInfo frx2) {
                int notes1 = newRevisions.get(frx1.getPermaId()) == null ? 0 : 1;
                int notes2 = newRevisions.get(frx2.getPermaId()) == null ? 0 : 1;
                int diff = notes2 - notes1;
                if (diff != 0) {
                    return diff;
                }
                return frx1.getFePath().compareTo(frx2.getFePath());
            }
        });
        Map<String, Object> attributes = FreemarkerUtil.init();
        attributes.put("orderedFrxs", orderedFrxs);
        attributes.put("newRevisions", newRevisions);
        attributes.put("revisionsAddedCount", revisionsAddedCount);
        attributes.put("review", notes.get(0).getEvent().getReview());
        String segment = this.emailTemplateRender.renderCrucibleTemplate(attributes, isHtml, TEMPLATE);
        FecruUser commonActioner = null;
        if (actioners.size() == 1) {
            commonActioner = (FecruUser)actioners.iterator().next();
        }
        Review review = (Review)reviews.iterator().next();
        return new Batch(this.emailTemplateRender.renderSubject(EmailThreadingHelper.buildSubjectForReview(review)), RevisionAddedBatchCreator.createSummary(revisionsAddedCount), segment, notifications, commonActioner, EmailThreadingHelper.buildThreadIdForReview(review));
    }

    protected static String createSummary(int revisionsAddedCount) {
        StringBuilder builder = new StringBuilder();
        builder.append(revisionsAddedCount).append(ExpressionUtil.pluralise(" file revision", " file revisions", revisionsAddedCount)).append(" added");
        return builder.toString();
    }

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return newNote instanceof RevisionAddedNotificationEvent && (existing == null || existing.getReview().equals(newNote.getReview()));
    }
}

