/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.AllCompletedNotificationEvent;
import com.cenqua.crucible.notification.AllUncompletedNotificationEvent;
import com.cenqua.crucible.notification.CompletedNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.ReviewerNotification;
import com.cenqua.crucible.notification.UncompletedNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class ReviewerBatchCreator
extends AbstractBatchCreator {
    static final String TEMPLATE = "batch-reviewer-note.ftl";

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        HashSet<Notification> notifications = new HashSet<Notification>();
        HashSet<Review> reviews = new HashSet<Review>();
        HashSet<FecruUser> actioners = new HashSet<FecruUser>();
        HashSet<FecruUser> complete = new HashSet<FecruUser>();
        HashSet<FecruUser> uncomplete = new HashSet<FecruUser>();
        for (Notification notification : notes) {
            Review noteReview;
            NotificationEvent event = notification.getEvent();
            if (!(event instanceof ReviewerNotification) || (noteReview = event.getReview()) == null) continue;
            FecruUser noteActioner = event.getActioner();
            if (event instanceof CompletedNotificationEvent || event instanceof AllCompletedNotificationEvent) {
                if (noteReview.isCompletedParticipant(noteActioner)) {
                    complete.add(noteActioner);
                }
            } else {
                if (!(event instanceof UncompletedNotificationEvent) && !(event instanceof AllUncompletedNotificationEvent)) continue;
                if (!noteReview.isCompletedParticipant(noteActioner)) {
                    uncomplete.add(noteActioner);
                }
            }
            notifications.add(notification);
            reviews.add(noteReview);
            actioners.add(noteActioner);
        }
        if (notifications.isEmpty()) {
            return null;
        }
        Map<String, Object> attributes = FreemarkerUtil.init();
        Review review = (Review)reviews.iterator().next();
        attributes.put("review", review);
        attributes.put("complete", complete);
        attributes.put("uncomplete", uncomplete);
        boolean allComplete = review.getCountActiveReviewers() == 0;
        attributes.put("allComplete", allComplete);
        boolean allUncomplete = review.getCountAllReviewers() > 0 && review.getCountCompletedReviewers() == 0;
        attributes.put("allUncomplete", allUncomplete);
        String segment = this.emailTemplateRender.renderCrucibleTemplate(attributes, isHtml, TEMPLATE);
        FecruUser commonUser = null;
        if (actioners.size() == 1) {
            commonUser = (FecruUser)actioners.iterator().next();
        }
        return new Batch(this.emailTemplateRender.renderSubject(EmailThreadingHelper.buildSubjectForReview(review)), ReviewerBatchCreator.createSummary(complete, uncomplete, allComplete), segment, notifications, commonUser, EmailThreadingHelper.buildThreadIdForReview(review));
    }

    protected static String createSummary(Set<FecruUser> complete, Set<FecruUser> uncomplete, boolean allComplete) {
        StringBuilder builder = new StringBuilder();
        if (allComplete) {
            builder.append("Everyone has finished reviewing");
        } else if (!complete.isEmpty()) {
            builder.append("Finished reviewing");
        } else if (!uncomplete.isEmpty()) {
            builder.append("Resumed reviewing");
        }
        return builder.toString();
    }

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return newNote instanceof ReviewerNotification && (existing == null || existing.getReview().equals(newNote.getReview()));
    }
}

