/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.ReviewReminderNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.util.DateHelper;
import com.google.common.primitives.Longs;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ReminderBatchCreator
extends AbstractBatchCreator {
    private static final String TEMPLATE = "review-reminder-notification.ftl";
    private static final int MAX_REVIEW_KEYS_IN_SUBJECT = 3;

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return newNote instanceof ReviewReminderNotificationEvent;
    }

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        Date now = new Date();
        ArrayList<ReviewReminderSegment> reminderAttributes = new ArrayList<ReviewReminderSegment>();
        HashSet<Notification> notifications = new HashSet<Notification>();
        HashSet<Integer> reviewsIncluded = new HashSet<Integer>();
        for (Notification notification : notes) {
            ReviewReminderNotificationEvent noteEvent = (ReviewReminderNotificationEvent)notification.getEvent();
            ReviewReminderSegment segmentData = ReviewReminderSegment.create(noteEvent.getReview(), noteEvent.getActioner(), notification.getUser(), noteEvent.getNote(), tz, now);
            if (segmentData == null || reviewsIncluded.contains(segmentData.review.getId())) continue;
            reviewsIncluded.add(segmentData.review.getId());
            reminderAttributes.add(segmentData);
            notifications.add(notification);
        }
        Collections.sort(reminderAttributes, new Comparator<ReviewReminderSegment>(){

            @Override
            public int compare(ReviewReminderSegment o1, ReviewReminderSegment o2) {
                return Longs.compare((long)o1.review.getDueDateTime(), (long)o2.review.getDueDateTime());
            }
        });
        ArrayList<String> reviewKeysForSubject = new ArrayList<String>(3);
        for (ReviewReminderSegment segment : reminderAttributes) {
            if (reviewKeysForSubject.size() == 3) break;
            reviewKeysForSubject.add(segment.review.getPermaId());
        }
        String emailSubject = String.format("Review Reminders: %s", String.join((CharSequence)", ", reviewKeysForSubject));
        Map<String, Object> map = FreemarkerUtil.init();
        map.put("segmentDataList", reminderAttributes);
        return new Batch(this.emailTemplateRender.renderSubject(emailSubject), "", this.emailTemplateRender.renderCrucibleTemplate(map, isHtml, TEMPLATE), notifications, null, null);
    }

    public static class ReviewReminderSegment {
        private final Review review;
        private final int percentCompleted;
        private final String prettyDueDateString;
        private final String message;
        private final FecruUser actioner;
        private final boolean isReviewer;
        private final boolean hasCompleted;
        private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("h:mma");

        public Review getReview() {
            return this.review;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isHasCompleted() {
            return this.hasCompleted;
        }

        public int getPercentCompleted() {
            return this.percentCompleted;
        }

        public String getDueDateString() {
            return this.prettyDueDateString;
        }

        public FecruUser getActioner() {
            return this.actioner;
        }

        public boolean isRecipientReviewer() {
            return this.isReviewer;
        }

        public static ReviewReminderSegment create(Review review, FecruUser actioner, FecruUser recipient, String message, TimeZone tz, Date now) {
            ReviewParticipant participantRecipient = review.getParticipant(recipient);
            return new ReviewReminderSegment(review, actioner, participantRecipient, message, tz, now);
        }

        private ReviewReminderSegment(Review review, FecruUser actioner, ReviewParticipant participantRecipient, String message, TimeZone tz, Date now) {
            this.review = review;
            this.message = message;
            this.prettyDueDateString = this.getPrettyTimePeriod(review, tz, now);
            this.isReviewer = participantRecipient.isReviewer();
            this.hasCompleted = participantRecipient.isAllComplete();
            this.percentCompleted = participantRecipient.getPercentageComplete();
            this.actioner = actioner;
        }

        private String getPrettyTimePeriod(Review review, TimeZone tz, Date now) {
            if (review.getDueDate() == null) {
                return null;
            }
            timeFormatter.setTimeZone(tz);
            String dayName = DateHelper.fuzzyDayName(review.getDueDateTime(), now.getTime(), tz, Locale.getDefault());
            return String.format("%s %s", timeFormatter.format(review.getDueDate()).toLowerCase(), dayName);
        }
    }
}

