/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.PluginNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class PluginBatchCreator
extends AbstractBatchCreator {
    private static final String TEMPLATE = "plugin-notification.ftl";

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return newNote instanceof PluginNotificationEvent && (existing == null || ((PluginNotificationEvent)existing).getGroupType().equals(((PluginNotificationEvent)newNote).getGroupType()) && existing.getEmailSubject().equals(newNote.getEmailSubject()));
    }

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        PluginNotificationEvent event = (PluginNotificationEvent)notes.iterator().next().getEvent();
        Map<String, Object> attributes = FreemarkerUtil.init();
        Review review = notes.get(0).getEvent().getReview();
        attributes.put("review", review);
        attributes.put("timezone", tz);
        attributes.put("body", isHtml ? event.getHtmlBody() : event.getTextBody());
        String segment = this.emailTemplateRender.renderFishEyeTemplate(attributes, isHtml, TEMPLATE);
        return new Batch(this.emailTemplateRender.renderSubject(event.getEmailSubject()), "", segment, new HashSet<Notification>(notes), event.getActioner(), EmailThreadingHelper.buildThreadId(event.getGroupType(), event.getCreateDate()));
    }
}

