/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.GeneralNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class GeneralBatchCreator
extends AbstractBatchCreator {
    private static final String TEMPLATE = "general-notification.ftl";

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        if (notes.size() > 1) {
            throw new IllegalStateException("Cannot batch general notifications");
        }
        Notification notification = notes.get(0);
        GeneralNotificationEvent notificationEvent = (GeneralNotificationEvent)notification.getEvent();
        Map<String, Object> attributes = FreemarkerUtil.init();
        attributes.put("notificationEvent", notificationEvent);
        String segment = this.emailTemplateRender.renderCrucibleTemplate(attributes, isHtml, TEMPLATE);
        Review review = notificationEvent.getReview();
        return new Batch(this.emailTemplateRender.renderSubject(EmailThreadingHelper.buildSubjectForReview(review)), notificationEvent.getNote(), segment, notification, EmailThreadingHelper.buildThreadIdForReview(review));
    }

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return existing == null && newNote instanceof GeneralNotificationEvent;
    }
}

