/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.CommentPropertiesChangedNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.CommentBatchCreator;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.crucible.util.HtmlAndTextPair;
import com.cenqua.fisheye.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommentPropertiesChangeBatchCreator
extends CommentBatchCreator {
    @VisibleForTesting
    protected static final String CUSTOM_COMMIT_CHANGE_TEMPLATE = "custom-comment-change-note.ftl";

    @Override
    public Batch getEmailSegment(@Nonnull List<Notification> notifications, @Nonnull TimeZone timeZone, boolean isHtml) throws IOException, TemplateException {
        if (notifications.isEmpty()) {
            return null;
        }
        Preconditions.checkState((notifications.size() == 1 ? 1 : 0) != 0, (Object)"Can't aggregate more than one notification in one email");
        Notification notification = notifications.get(0);
        NotificationEvent event = notification.getEvent();
        Preconditions.checkState((boolean)(event instanceof CommentPropertiesChangedNotificationEvent), (Object)("Unsupported notification event type: " + event.getClass().getName()));
        CommentPropertiesChangedNotificationEvent typedEvent = (CommentPropertiesChangedNotificationEvent)event;
        Comment comment = typedEvent.getComment();
        Preconditions.checkState((comment != null ? 1 : 0) != 0, (Object)"Undefined comment");
        Comment rootComment = comment.getRootComment();
        FecruUser actioner = typedEvent.getActioner();
        Review review = typedEvent.getReview();
        HtmlAndTextPair headerNote = typedEvent.getHeaderNote();
        HtmlAndTextPair commentNote = typedEvent.getCommentNote();
        Map<String, Object> context = FreemarkerUtil.init();
        context.put("review", review);
        context.put("rootComment", Pair.newInstance(this.getFRXForRootComment(rootComment), rootComment));
        context.put("actionedComment", comment);
        context.put("formatter", EMAIL_COMMENTS_FORMATTER);
        context.put("timezone", timeZone);
        context.put("changeDescription", headerNote);
        context.put("commentNote", commentNote);
        String segment = this.emailTemplateRender.renderCrucibleTemplate(context, isHtml, CUSTOM_COMMIT_CHANGE_TEMPLATE);
        return new Batch(this.emailTemplateRender.renderSubject(EmailThreadingHelper.buildSubjectForReview(review)), headerNote.getPlainText(), segment, (Set<Notification>)ImmutableSet.of((Object)notification), actioner, EmailThreadingHelper.buildThreadIdForReview(review));
    }

    @Override
    public boolean accepts(@Nullable NotificationEvent existing, @Nonnull NotificationEvent newNote) {
        return existing == null && newNote instanceof CommentPropertiesChangedNotificationEvent;
    }
}

