/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.ReplyNotificationEvent;
import com.cenqua.crucible.notification.ReviewCommentNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.util.EmailAllCommentsFormatter;
import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CommentBatchCreator
extends AbstractBatchCreator {
    static final String TEMPLATE = "batch-comment-note.ftl";
    static final Comparator<Pair<FileRevisionExtraInfo, Comment>> commentPathComparator = new PathOrderComparator();
    static final EmailAllCommentsFormatter EMAIL_COMMENTS_FORMATTER = new EmailAllCommentsFormatter("    ", 6);

    @Override
    public Batch getEmailSegment(List<Notification> notes, TimeZone tz, boolean isHtml) throws IOException, TemplateException {
        FecruUser user = notes.get(0).getUser();
        HashSet<Comment> rawRootComments = new HashSet<Comment>();
        HashSet<Notification> notifications = new HashSet<Notification>();
        HashSet<FecruUser> actioners = new HashSet<FecruUser>();
        HashSet<Comment> newComments = new HashSet<Comment>();
        for (Notification notification : notes) {
            ReviewCommentNotificationEvent note;
            Comment comment;
            if (!(notification.getEvent() instanceof ReviewCommentNotificationEvent) || (comment = (note = (ReviewCommentNotificationEvent)notification.getEvent()) instanceof ReplyNotificationEvent ? ((ReplyNotificationEvent)note).getReply() : note.getComment()) == null || !comment.isVisibleToAll()) continue;
            newComments.add(comment);
            rawRootComments.add(comment.getRootComment());
            notifications.add(notification);
            actioners.add(note.getActioner());
        }
        if (notifications.isEmpty()) {
            return null;
        }
        ArrayList<Pair<FileRevisionExtraInfo, Comment>> rootComments = new ArrayList<Pair<FileRevisionExtraInfo, Comment>>();
        for (Comment rootComment : rawRootComments) {
            rootComments.add(Pair.newInstance(this.getFRXForRootComment(rootComment), rootComment));
        }
        Collections.sort(rootComments, new PathOrderComparator());
        Map<String, Object> map = FreemarkerUtil.init();
        Review review = notes.get(0).getEvent().getReview();
        map.put("review", review);
        map.put("user", user);
        map.put("rootComments", rootComments);
        map.put("newComments", newComments);
        map.put("formatter", EMAIL_COMMENTS_FORMATTER);
        map.put("timezone", tz);
        String segment = this.emailTemplateRender.renderCrucibleTemplate(map, isHtml, TEMPLATE);
        FecruUser commonActioner = null;
        if (actioners.size() == 1) {
            commonActioner = (FecruUser)actioners.iterator().next();
        }
        return new Batch(this.emailTemplateRender.renderSubject(EmailThreadingHelper.buildSubjectForReview(review)), CommentBatchCreator.buildSummary(newComments.size()), segment, notifications, commonActioner, EmailThreadingHelper.buildThreadIdForReview(review));
    }

    protected static String buildSummary(int numberOfNewComments) {
        StringBuilder builder = new StringBuilder();
        builder.append(numberOfNewComments).append(ExpressionUtil.pluralise(" comment", " comments", numberOfNewComments)).append(" added");
        return builder.toString();
    }

    @Override
    public boolean accepts(NotificationEvent existing, NotificationEvent newNote) {
        return newNote instanceof ReviewCommentNotificationEvent && (existing == null || existing.getReview().equals(newNote.getReview()));
    }

    public FileRevisionExtraInfo getFRXForRootComment(Comment rootComment) {
        FileRevisionExtraInfo frx = null;
        if (rootComment.getFrxComment() != null) {
            frx = rootComment.getFrxComment().getFrx();
        } else if (rootComment.getInlineComment() != null) {
            frx = rootComment.getInlineComment().getFrx();
        }
        return frx;
    }

    private static class PathOrderComparator
    implements Comparator<Pair<FileRevisionExtraInfo, Comment>> {
        private PathOrderComparator() {
        }

        private boolean noFePath(Pair<FileRevisionExtraInfo, Comment> p2) {
            return p2.getFirst() == null || p2.getFirst().getFePath() == null;
        }

        @Override
        public int compare(Pair<FileRevisionExtraInfo, Comment> p1, Pair<FileRevisionExtraInfo, Comment> p2) {
            if (this.noFePath(p1)) {
                if (this.noFePath(p2)) {
                    return p1.getSecond().getCreateDateTime().compareTo(p2.getSecond().getCreateDateTime());
                }
                return -1;
            }
            if (this.noFePath(p2)) {
                return 1;
            }
            int pathDiff = p1.getFirst().getFePath().compareTo(p2.getFirst().getFePath());
            if (pathDiff != 0) {
                return pathDiff;
            }
            return p1.getSecond().getCreateDateTime().compareTo(p2.getSecond().getCreateDateTime());
        }
    }
}

