/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch;

import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.notification.batch.BatchCreatorType;
import com.cenqua.crucible.notification.batch.NotificationBatchProvider;
import com.cenqua.fisheye.logging.Logs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultNotificationBatchProvider
implements NotificationBatchProvider {
    private final Map<BatchCreatorType, Set<Integer>> batchTypes = new HashMap<BatchCreatorType, Set<Integer>>();
    private final Set<Integer> notificationTypes = new HashSet<Integer>();

    public DefaultNotificationBatchProvider() {
        this.registerNotification(NotificationManager.TYPE_STATE_CHANGE, BatchCreatorType.STATE_CHANGE);
        this.registerNotification(NotificationManager.TYPE_GENERAL, BatchCreatorType.GENERAL);
        this.registerNotification(NotificationManager.TYPE_REVIEWER_COMPLETE, BatchCreatorType.REVIEWER);
        this.registerNotification(NotificationManager.TYPE_REVIEWER_INCOMPLETE, BatchCreatorType.REVIEWER);
        this.registerNotification(NotificationManager.TYPE_ALL_COMPLETE, BatchCreatorType.REVIEWER);
        this.registerNotification(NotificationManager.TYPE_ALL_NO_LONGER_COMPLETE, BatchCreatorType.REVIEWER);
        this.registerNotification(NotificationManager.TYPE_COMMENTED, BatchCreatorType.COMMENT);
        this.registerNotification(NotificationManager.TYPE_REPLIED, BatchCreatorType.COMMENT);
        this.registerNotification(NotificationManager.TYPE_REVISION_ADDED, BatchCreatorType.REVISION_ADDED);
        this.registerNotification(NotificationManager.TYPE_CS_COMMENTED, BatchCreatorType.CHANGESET_COMMENT);
        this.registerNotification(NotificationManager.TYPE_CS_REPLIED, BatchCreatorType.CHANGESET_COMMENT);
        this.registerNotification(NotificationManager.TYPE_PLUGIN, BatchCreatorType.PLUGIN);
        this.registerNotification(NotificationManager.TYPE_REMINDER, BatchCreatorType.REMINDER);
        this.registerNotification(NotificationManager.TYPE_SHARE_CONTENT, BatchCreatorType.SHARE_CONTENT);
        this.registerNotification(NotificationManager.TYPE_MENTION_USER_IN_CHANGESET_COMMENT, BatchCreatorType.MENTION_USER);
        this.registerNotification(NotificationManager.TYPE_MENTION_USER_IN_REVIEW_COMMENT, BatchCreatorType.MENTION_USER);
        this.registerNotification(NotificationManager.TYPE_MENTION_USER_IN_REVIEW_DESCRIPTION, BatchCreatorType.MENTION_USER);
        this.registerNotification(NotificationManager.TYPE_COMMENT_PROPERTIES_CHANGE, BatchCreatorType.COMMENT_PROPERTIES_CHANGE);
    }

    public boolean registerNotification(Integer noteType, BatchCreatorType messageCreator) {
        if (!this.notificationTypes.add(noteType)) {
            Logs.APP_LOG.warn((Object)("Tried to register notification type " + noteType + " to " + messageCreator.name() + ". Cannot register same type more than once."));
            return false;
        }
        Set<Integer> noteTypes = this.batchTypes.get((Object)messageCreator);
        if (noteTypes == null) {
            noteTypes = new HashSet<Integer>();
            this.batchTypes.put(messageCreator, noteTypes);
        }
        noteTypes.add(noteType);
        return true;
    }

    @Override
    public final BatchCreatorType getBatcher(NotificationEvent note) {
        Integer noteType = note.getType();
        if (this.notificationTypes.contains(noteType)) {
            for (BatchCreatorType messageCreator : this.batchTypes.keySet()) {
                for (Integer type : this.batchTypes.get((Object)messageCreator)) {
                    if (!type.equals(noteType)) continue;
                    return messageCreator;
                }
            }
        }
        return null;
    }
}

