/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.notification.Notification;
import java.util.Collections;
import java.util.Set;

public class Batch {
    private final String body;
    private final FecruUser commonActioner;
    private final String mailThreadId;
    private final Set<Notification> notifications;
    private final String subject;
    private final String summary;

    public Batch(String subject, String summary, String body, Set<Notification> notifications, FecruUser commonActioner, String mailThreadId) {
        this.subject = subject;
        this.summary = summary;
        this.body = body;
        this.notifications = notifications;
        this.commonActioner = commonActioner;
        this.mailThreadId = mailThreadId;
    }

    public Batch(String subject, String summary, String body, Notification notification, String mailThreadId) {
        this.subject = subject;
        this.summary = summary;
        this.body = body;
        this.commonActioner = notification.getEvent().getActioner();
        this.mailThreadId = mailThreadId;
        this.notifications = Collections.singleton(notification);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getBody() {
        return this.body;
    }

    public Set<Notification> getNotifications() {
        return this.notifications;
    }

    public FecruUser getCommonActioner() {
        return this.commonActioner;
    }

    public String getMailThreadId() {
        return this.mailThreadId;
    }
}

