/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.notification.BaseReviewNotificationEvent;
import com.cenqua.crucible.notification.NotificationManager;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class StateNotificationEvent
extends BaseReviewNotificationEvent {
    public StateNotificationEvent() {
    }

    public StateNotificationEvent(FecruUser actioner, Review review) {
        super(actioner);
        this.setReview(review);
        this.setNote(review.getStateName());
    }

    @Override
    public Integer getType() {
        return NotificationManager.TYPE_STATE_CHANGE;
    }

    public String getState() {
        return StringUtils.defaultString((String)this.getNote());
    }

    @Override
    public String getDescription() {
        return "State Change";
    }

    @Override
    public List<Role> getRolesToNotify() {
        return StateManager.INSTANCE.getStateChangeNotificationRules(this.getState());
    }

    @Override
    public Integer getEmailNotificationPref(FecruUser user) {
        return user.getUserProfile().getStateChangeEmailNotification();
    }
}

